/*
 * Decompiled with CFR 0.152.
 */
package com.webfuzzing.commons.report;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "file_path", "name", "start_line", "end_line"})
public class TestCase {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="A unique identifier for a test case. It could include its name and file location.")
    private String id;
    @JsonProperty(value="file_path")
    @JsonPropertyDescription(value="A relative path used to unique locate a test suite file.")
    private String filePath;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of the test case, as it appears in the generated test file.")
    private String name;
    @JsonProperty(value="start_line")
    @JsonPropertyDescription(value="The line number in the generated test suite file where the code of this test case starts.")
    private Integer startLine;
    @JsonProperty(value="end_line")
    @JsonPropertyDescription(value="The line number in the generated test suite file where the code of this test case ends.")
    private Integer endLine;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="file_path")
    public String getFilePath() {
        return this.filePath;
    }

    @JsonProperty(value="file_path")
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="start_line")
    public Integer getStartLine() {
        return this.startLine;
    }

    @JsonProperty(value="start_line")
    public void setStartLine(Integer startLine) {
        this.startLine = startLine;
    }

    @JsonProperty(value="end_line")
    public Integer getEndLine() {
        return this.endLine;
    }

    @JsonProperty(value="end_line")
    public void setEndLine(Integer endLine) {
        this.endLine = endLine;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestCase.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("filePath");
        sb.append('=');
        sb.append(this.filePath == null ? "<null>" : this.filePath);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("startLine");
        sb.append('=');
        sb.append(this.startLine == null ? "<null>" : this.startLine);
        sb.append(',');
        sb.append("endLine");
        sb.append('=');
        sb.append(this.endLine == null ? "<null>" : this.endLine);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.endLine == null ? 0 : this.endLine.hashCode());
        result = result * 31 + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = result * 31 + (this.startLine == null ? 0 : this.startLine.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TestCase)) {
            return false;
        }
        TestCase rhs = (TestCase)other;
        return (this.endLine == rhs.endLine || this.endLine != null && this.endLine.equals(rhs.endLine)) && (this.filePath == rhs.filePath || this.filePath != null && this.filePath.equals(rhs.filePath)) && (this.startLine == rhs.startLine || this.startLine != null && this.startLine.equals(rhs.startLine)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }
}

