/*
 * Decompiled with CFR 0.152.
 */
package com.webguys.maven.plugin.st;

import com.webguys.maven.plugin.st.Template;
import java.io.File;
import java.util.List;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroupDir;
import org.stringtemplate.v4.misc.ErrorBuffer;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class StringTemplateMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenSession session;
    private BuildPluginManager pluginManager;
    private ProjectDependenciesResolver dependenciesResolver;
    private List<Template> templates;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (Template template : this.templates) {
            File templateDirectory = this.getTemplateDirectory(template);
            STGroupDir group = new STGroupDir(templateDirectory.getAbsolutePath());
            ErrorBuffer errorBuffer = new ErrorBuffer();
            group.setListener((STErrorListener)errorBuffer);
            ST st = group.getInstanceOf(template.getName());
            if (null == st || !errorBuffer.errors.isEmpty()) {
                throw new MojoExecutionException(String.format("Unable to execute template. %n%s", errorBuffer.toString()));
            }
            MojoExecutor.ExecutionEnvironment executionEnvironment = MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager);
            template.invokeController(st, executionEnvironment, this.dependenciesResolver, this.getLog());
            template.installProperties(st);
            template.render(st, this.project, this.getLog());
        }
    }

    private File getTemplateDirectory(Template template) {
        File templateDirectory = template.getDirectory();
        if (!templateDirectory.isAbsolute()) {
            templateDirectory = new File(this.project.getBasedir(), templateDirectory.getPath());
        }
        return templateDirectory;
    }
}

