/*
 * Decompiled with CFR 0.152.
 */
package com.webguys.maven.plugin.st;

import com.webguys.maven.plugin.st.Controller;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STWriter;
import org.stringtemplate.v4.misc.ErrorBuffer;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class Template {
    private File directory;
    private String name;
    private File target;
    private Controller controller;
    private Map<String, String> properties;

    public File getDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.name;
    }

    public void invokeController(ST st, MojoExecutor.ExecutionEnvironment executionEnvironment, ProjectDependenciesResolver dependenciesResolver, Log log) throws MojoExecutionException {
        if (null != this.controller) {
            this.controller.invoke(st, executionEnvironment, dependenciesResolver, log);
        }
    }

    public void installProperties(ST st) {
        if (null != this.properties) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                st.add(entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    public void render(ST st, MavenProject project, Log log) throws MojoExecutionException {
        try {
            File outputFile = this.prepareOutputFile(project.getBasedir());
            this.prepareCompilerSourceRoot(outputFile, project, log);
            FileWriter fileWriter = new FileWriter(outputFile);
            ErrorBuffer listener = new ErrorBuffer();
            st.write((STWriter)new AutoIndentWriter((Writer)fileWriter), (STErrorListener)listener);
            fileWriter.flush();
            fileWriter.close();
            if (!listener.errors.isEmpty()) {
                throw new MojoExecutionException(listener.toString());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Unable to write output file: %s. (%s)", this.target.getAbsolutePath(), e.getMessage()), (Exception)e);
        }
    }

    private File prepareOutputFile(File baseDirectory) throws MojoExecutionException, IOException {
        File outputFile = this.target;
        if (!outputFile.isAbsolute()) {
            outputFile = new File(baseDirectory, outputFile.getPath());
        }
        if (!outputFile.exists()) {
            if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                throw new MojoExecutionException(String.format("Unable to fully create the output directory: %s", this.target.getParentFile()));
            }
            if (!outputFile.createNewFile()) {
                throw new MojoExecutionException(String.format("Unable to create the output file: %s", this.target));
            }
        }
        return outputFile;
    }

    private void prepareCompilerSourceRoot(File file, MavenProject project, Log log) {
        String path = file.getPath();
        if (file.getName().endsWith("java") && path.contains("generated-sources")) {
            int index = path.indexOf("generated-sources") + 18;
            index = path.indexOf(File.separator, index);
            String sourceRoot = path.substring(0, index);
            log.info((CharSequence)("Adding compile source root: " + sourceRoot));
            project.addCompileSourceRoot(sourceRoot);
        }
    }
}

