/*
 * This file is part of WebLookAndFeel library.
 *
 * WebLookAndFeel library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * WebLookAndFeel library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WebLookAndFeel library.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.alee.api.clone;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;

import java.io.Serializable;

/**
 * Unknown object type clone case resolver.
 * It is asked to choose clone result for objects of unknown type.
 *
 * @author Mikle Garin
 * @see <a href="https://github.com/mgarin/weblaf/wiki/How-to-use-Clone">How to use Clone</a>
 * @see Clone
 */
public interface UnknownResolver extends Serializable
{
    /**
     * Returns clone result for object of unknown type.
     *
     * @param clone  {@link Clone} algorithm
     * @param object object to clone
     * @return clone result for object of unknown type.
     */
    @Nullable
    public Object resolve ( @NotNull RecursiveClone clone, @NotNull Object object );
}