/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.clone.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.clone.CloneException;
import com.alee.api.clone.GlobalCloneBehavior;
import com.alee.api.clone.RecursiveClone;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.clone.behavior.PreserveOnClone;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.reflection.ModifierType;
import com.alee.utils.reflection.Unsafe;
import java.lang.reflect.Field;
import java.util.List;

public class ReflectionCloneBehavior<O>
implements GlobalCloneBehavior<O> {
    @NotNull
    private final Policy policy;
    @NotNull
    private final List<ModifierType> ignoredModifiers;

    public ReflectionCloneBehavior(@NotNull Policy policy, ModifierType ... ignoredModifiers) {
        this.policy = policy;
        this.ignoredModifiers = CollectionUtils.asList(ignoredModifiers);
    }

    @Override
    public boolean supports(@NotNull RecursiveClone clone, @NotNull Object object) {
        return this.policy == Policy.all || object instanceof Cloneable;
    }

    @Override
    @NotNull
    public O clone(@NotNull RecursiveClone clone, @NotNull O object, int depth) {
        Object copy = Unsafe.allocateInstance(object.getClass());
        List<Field> fields = ReflectUtils.getFields(object);
        if (!fields.isEmpty()) {
            clone.store(object, copy);
            for (Field field : fields) {
                Object value;
                boolean omit;
                if (!ReflectUtils.hasNoneOfModifiers(field, this.ignoredModifiers)) continue;
                boolean preserve = field.getAnnotation(PreserveOnClone.class) != null;
                boolean bl = omit = field.getAnnotation(OmitOnClone.class) != null;
                if (preserve && omit) {
                    throw new CloneException("Mutually exclusive annotations are used for field: " + field);
                }
                if (preserve) {
                    try {
                        value = field.get(object);
                        ReflectUtils.setFieldValue(copy, field, value);
                        continue;
                    }
                    catch (Exception e) {
                        throw new CloneException("Unable to preserve object field: " + field, e);
                    }
                }
                if (omit) continue;
                try {
                    value = field.get(object);
                    Object valueCopy = clone.clone(value, depth + 1);
                    ReflectUtils.setFieldValue(copy, field, valueCopy);
                }
                catch (Exception e) {
                    throw new CloneException("Unable to clone object field: " + field, e);
                }
            }
        }
        return (O)copy;
    }

    @Override
    public boolean isStorable() {
        return true;
    }

    public static enum Policy {
        cloneable,
        all;

    }
}

