/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.data;

import com.alee.api.annotations.NotNull;
import javax.swing.SwingConstants;

public enum BoxOrientation implements SwingConstants
{
    center(0),
    top(1),
    left(10),
    bottom(3),
    right(11);

    private final int value;

    private BoxOrientation(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isCenter() {
        return this == center;
    }

    public boolean isTop() {
        return this == top;
    }

    public boolean isLeft() {
        return this == left;
    }

    public boolean isBottom() {
        return this == bottom;
    }

    public boolean isRight() {
        return this == right;
    }

    @NotNull
    public static BoxOrientation get(int value) {
        BoxOrientation orientation;
        switch (value) {
            case 1: {
                orientation = top;
                break;
            }
            case 2: 
            case 10: {
                orientation = left;
                break;
            }
            case 3: {
                orientation = bottom;
                break;
            }
            case 4: 
            case 11: {
                orientation = right;
                break;
            }
            default: {
                orientation = center;
            }
        }
        return orientation;
    }
}

