/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.version;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.api.version.VersionType;
import com.alee.utils.TextUtils;
import java.io.Serializable;
import java.util.List;

public final class Version
implements Comparable<Version>,
Serializable {
    @NotNull
    private final String name;
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final VersionType type;

    public Version(@Nullable Class cls) {
        this(cls != null ? cls.getPackage() : null);
    }

    public Version(@Nullable Package pkg) {
        this(pkg != null ? pkg.getSpecificationTitle() : null, pkg != null ? pkg.getSpecificationVersion() : null);
    }

    public Version(@Nullable String name, @Nullable String version) {
        if (TextUtils.notEmpty(name) && TextUtils.notEmpty(version)) {
            this.name = name;
            int typeSeparator = version.indexOf("-");
            String versionNumber = typeSeparator != -1 ? version.substring(0, typeSeparator) : version;
            List<String> majorMinorPatch = TextUtils.stringToList(versionNumber, ".");
            this.major = majorMinorPatch.size() > 0 ? Integer.parseInt(majorMinorPatch.get(0)) : 0;
            this.minor = majorMinorPatch.size() > 1 ? Integer.parseInt(majorMinorPatch.get(1)) : 0;
            this.patch = majorMinorPatch.size() > 2 ? Integer.parseInt(majorMinorPatch.get(2)) : 0;
            String type = version.substring(typeSeparator + 1).toLowerCase();
            this.type = typeSeparator != -1 ? VersionType.valueOf(type) : VersionType.release;
        } else {
            this.name = "Unknown";
            this.major = 0;
            this.minor = 0;
            this.patch = 0;
            this.type = VersionType.snapshot;
        }
    }

    public Version(@NotNull String name, int major, int minor, int patch, @NotNull VersionType type) {
        this.name = name;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.type = type;
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    @NotNull
    public VersionType type() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.major, this.minor, this.patch, this.type});
    }

    @Override
    public int compareTo(Version version) {
        int result = this.major() < version.major() ? -1 : (this.major() > version.major() ? 1 : (this.minor() < version.minor() ? -1 : (this.minor() > version.minor() ? 1 : (this.patch() < version.patch() ? -1 : (this.patch() > version.patch() ? 1 : new Integer(version.type().ordinal()).compareTo(this.type().ordinal()))))));
        return result;
    }

    @NotNull
    public String toString() {
        return "v" + this.major + "." + this.minor + "." + this.patch + (this.type != VersionType.release ? "-" + this.type.name().toUpperCase() : "");
    }
}

