/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.ValueConverter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@XStreamAlias(value="value")
@XStreamConverter(value=ValueConverter.class)
public final class Value
implements Cloneable,
Serializable {
    @XStreamAsAttribute
    @XStreamAlias(value="lang")
    private Locale locale;
    @XStreamImplicit
    @NotNull
    private List<Text> texts;

    public Value() {
        this(Locale.getDefault(), new ArrayList<Text>(0));
    }

    public Value(@NotNull Locale locale) {
        this(locale, new ArrayList<Text>(0));
    }

    public Value(@NotNull Locale locale, Text ... texts) {
        this(locale, CollectionUtils.asList(texts));
    }

    public Value(@NotNull Locale locale, @NotNull List<Text> texts) {
        this.locale = locale;
        this.texts = texts;
    }

    @NotNull
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(@NotNull Locale locale) {
        this.locale = locale;
    }

    @NotNull
    public List<Text> getTexts() {
        return this.texts;
    }

    public void setTexts(@NotNull List<Text> texts) {
        this.texts = texts;
    }

    public void addText(@NotNull Text text) {
        this.texts.add(text);
    }

    public void removeText(@NotNull Text text) {
        this.texts.remove(text);
    }

    public void clearTexts() {
        this.texts.clear();
    }

    public int textsCount() {
        return this.texts.size();
    }

    @Nullable
    public Text getText() {
        return this.getText(null);
    }

    @Nullable
    public Text getText(@Nullable String state) {
        Text result = null;
        for (Text text : this.texts) {
            if (!Objects.equals((Object)text.getState(), (Object)state)) continue;
            result = text;
            break;
        }
        return result;
    }

    @NotNull
    public String toString() {
        return LanguageUtils.toString(this.getLocale()) + " -> {" + TextUtils.listToString(this.texts, ";") + "}";
    }
}

