/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.proxy;

import com.alee.api.jdk.Objects;
import com.alee.api.jdk.Supplier;
import com.alee.managers.proxy.ProxySettings;
import com.alee.managers.proxy.SystemProxyConfirmationSupport;
import com.alee.managers.settings.SettingsManager;
import com.alee.utils.EncryptionUtils;
import com.alee.utils.XmlUtils;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Properties;

public final class ProxyManager {
    public static final String SETTINGS_GROUP = "ProxyManager";
    public static final String PROXY_SETTINGS = "ProxySettings";
    public static final String AUTO_SETTINGS_ON = "AutoSettingsOn";
    public static final String ALWAYS_USE_SYSTEM_SETTINGS = "AlwaysUseSystemSettings";
    public static final String SAVE_SETTINGS = "SaveSettings";
    protected static boolean autoDetectionEnabled = false;
    protected static Authenticator authenticator;
    protected static boolean proxySet;
    protected static SystemProxyConfirmationSupport systemProxyConfirmationSupport;
    protected static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            XmlUtils.processAnnotations(ProxySettings.class);
            if (autoDetectionEnabled) {
                ProxySettings proxySettings = ProxyManager.getProxySettings();
                ProxySettings systemProxySettings = ProxyManager.getSystemProxySettings();
                if (proxySettings.isUseProxy() != systemProxySettings.isUseProxy() || Objects.notEquals((Object)proxySettings.getProxyHost(), (Object)systemProxySettings.getProxyHost()) || Objects.notEquals((Object)proxySettings.getProxyPort(), (Object)systemProxySettings.getProxyPort())) {
                    if (systemProxyConfirmationSupport == null || ProxyManager.isAutoSettingsInitialization()) {
                        if (ProxyManager.isAlwaysUseSystemSettings()) {
                            proxySettings = systemProxySettings;
                        }
                    } else {
                        boolean useSystemProxy = systemProxyConfirmationSupport.shouldUseSystemProxy();
                        if (useSystemProxy) {
                            proxySettings = systemProxySettings;
                        }
                        if (systemProxyConfirmationSupport.alwaysDoTheSame()) {
                            ProxyManager.setAutoSettingsInitialization(true);
                            ProxyManager.setAlwaysUseSystemSettings(useSystemProxy);
                        }
                    }
                }
                ProxyManager.setProxySettings(proxySettings);
            }
            initialized = true;
        }
    }

    public static boolean isAutoDetectionEnabled() {
        return autoDetectionEnabled;
    }

    public static void setAutoDetectionEnabled(boolean enabled) {
        autoDetectionEnabled = enabled;
    }

    public static Authenticator getAuthenticator() {
        return authenticator;
    }

    public static void setAuthenticator(Authenticator authenticator) {
        ProxyManager.authenticator = authenticator;
        if (initialized && ProxyManager.getProxySettings().isUseProxy()) {
            Authenticator.setDefault(authenticator);
        }
    }

    public static void setAutoSettingsInitialization(boolean enabled) {
        SettingsManager.set(SETTINGS_GROUP, AUTO_SETTINGS_ON, enabled);
    }

    public static boolean isAutoSettingsInitialization() {
        return SettingsManager.get(SETTINGS_GROUP, AUTO_SETTINGS_ON, false);
    }

    public static void setAlwaysUseSystemSettings(boolean useSystem) {
        SettingsManager.set(SETTINGS_GROUP, ALWAYS_USE_SYSTEM_SETTINGS, useSystem);
    }

    public static boolean isAlwaysUseSystemSettings() {
        return SettingsManager.get(SETTINGS_GROUP, ALWAYS_USE_SYSTEM_SETTINGS, false);
    }

    public static ProxySettings getProxySettings() {
        return SettingsManager.get(SETTINGS_GROUP, PROXY_SETTINGS, new Supplier<ProxySettings>(){

            @Override
            public ProxySettings get() {
                return ProxyManager.getSystemProxySettings();
            }
        });
    }

    public static void setProxySettings() {
        if (!proxySet) {
            ProxyManager.setProxySettings(ProxyManager.getProxySettings());
        }
    }

    public static void setEmptyProxySettings() {
        ProxyManager.setProxySettings(new ProxySettings());
    }

    public static ProxySettings setSystemProxySettings() {
        ProxySettings proxySettings = ProxyManager.getSystemProxySettings();
        ProxyManager.setProxySettings(proxySettings);
        return proxySettings;
    }

    public static void setProxySettings(String host, String port) {
        ProxyManager.setProxySettings(new ProxySettings(host, port));
    }

    public static void setProxySettings(String host, String port, String login, String password) {
        ProxyManager.setProxySettings(new ProxySettings(host, port, login, password));
    }

    public static void setProxySettings(ProxySettings settings) {
        ProxyManager.setProxySettings(settings, true);
    }

    public static void setProxySettings(ProxySettings settings, boolean save) {
        proxySet = true;
        if (save) {
            SettingsManager.set(SETTINGS_GROUP, PROXY_SETTINGS, settings);
        }
        Properties systemSettings = System.getProperties();
        systemSettings.setProperty("proxySet", "" + settings.isUseProxy());
        if (settings.isUseProxy()) {
            systemSettings.setProperty("proxyHost", "" + settings.getProxyHost());
            systemSettings.setProperty("proxyPort", "" + settings.getProxyPort());
            systemSettings.setProperty("nonProxyHosts", "" + settings.getNonProxyHosts());
            Authenticator.setDefault(authenticator);
        } else {
            systemSettings.setProperty("proxyHost", "");
            systemSettings.setProperty("proxyPort", "");
            systemSettings.setProperty("nonProxyHosts", "");
            Authenticator.setDefault(null);
        }
    }

    public static URLConnection getURLConnection(URL url) throws IOException {
        ProxyManager.setProxySettings();
        ProxySettings proxySettings = ProxyManager.getProxySettings();
        if (proxySettings.isUseProxy()) {
            URLConnection connection = url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxySettings.getProxyHost(), proxySettings.getProxyPortInt())));
            ProxyManager.setupProxy(connection);
            return connection;
        }
        return url.openConnection();
    }

    public static void setupProxy(URLConnection urlConnection) {
        ProxyManager.setProxySettings();
        ProxySettings proxySettings = ProxyManager.getProxySettings();
        if (proxySettings.isUseProxy() && proxySettings.isUseProxyAuthentification()) {
            String toEncode = proxySettings.getProxyLogin() + ":" + proxySettings.getProxyPassword();
            urlConnection.setRequestProperty("Proxy-Authorization", "Basic " + EncryptionUtils.base64encode(toEncode));
        }
    }

    public static ProxySettings getSystemProxySettings() {
        InetSocketAddress address;
        ProxySettings proxySettings = new ProxySettings();
        System.setProperty("java.net.useSystemProxies", "true");
        Proxy proxy = ProxyManager.getSystemHttpProxy();
        if (proxy != null && (address = (InetSocketAddress)proxy.address()) != null && address.getHostName() != null) {
            proxySettings.setUseProxy(true);
            proxySettings.setProxyHost(address.getHostName());
            proxySettings.setProxyPort("" + address.getPort());
        }
        System.setProperty("java.net.useSystemProxies", "false");
        return proxySettings;
    }

    protected static Proxy getSystemHttpProxy() {
        try {
            ProxySelector def = ProxySelector.getDefault();
            List<Proxy> l = def.select(new URI("http://www.google.com"));
            for (Proxy proxy : l) {
                if (proxy == null || !proxy.type().equals((Object)Proxy.Type.HTTP)) continue;
                return proxy;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static SystemProxyConfirmationSupport getSystemProxyConfirmationSupport() {
        return systemProxyConfirmationSupport;
    }

    public static void setSystemProxyConfirmationSupport(SystemProxyConfirmationSupport support) {
        systemProxyConfirmationSupport = support;
    }

    static {
        proxySet = false;
        systemProxyConfirmationSupport = null;
        initialized = false;
    }
}

