/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.task;

import com.alee.api.Identifiable;
import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.utils.concurrent.DaemonThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class TaskGroup
implements Identifiable {
    @NotNull
    protected final String id;
    @NotNull
    protected final ThreadFactory threadFactory;
    protected final int maxThreadsCount;
    @Nullable
    protected ExecutorService executorService;

    public TaskGroup(@NotNull String id) {
        this(id, new DaemonThreadFactory(id), 0);
    }

    public TaskGroup(@NotNull String id, int maxThreadsCount) {
        this(id, new DaemonThreadFactory(id), maxThreadsCount);
    }

    public TaskGroup(@NotNull String id, @NotNull ThreadFactory threadFactory) {
        this(id, threadFactory, 0);
    }

    public TaskGroup(@NotNull String id, @NotNull ThreadFactory threadFactory, int maxThreadsCount) {
        this.id = Objects.requireNonNull(id, "ThreadGroup identifier must be specified");
        this.threadFactory = Objects.requireNonNull(threadFactory, "ThreadFactory must be specified");
        this.maxThreadsCount = maxThreadsCount;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Future<?> execute(@NotNull Runnable runnable) {
        return this.executorService().submit(runnable);
    }

    @NotNull
    public <V> Future<V> execute(@NotNull Callable<V> callable) {
        return this.executorService().submit(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.executorService != null) {
            TaskGroup taskGroup = this;
            synchronized (taskGroup) {
                if (this.executorService != null) {
                    this.executorService.shutdown();
                    this.executorService = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        if (this.executorService != null) {
            TaskGroup taskGroup = this;
            synchronized (taskGroup) {
                if (this.executorService != null) {
                    this.executorService.shutdownNow();
                    this.executorService = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ExecutorService executorService() {
        if (this.executorService == null) {
            TaskGroup taskGroup = this;
            synchronized (taskGroup) {
                if (this.executorService == null) {
                    switch (this.maxThreadsCount) {
                        case 0: {
                            this.executorService = Executors.newCachedThreadPool(this.threadFactory);
                            break;
                        }
                        case 1: {
                            this.executorService = Executors.newSingleThreadExecutor(this.threadFactory);
                            break;
                        }
                        default: {
                            this.executorService = Executors.newFixedThreadPool(this.maxThreadsCount, this.threadFactory);
                        }
                    }
                }
            }
        }
        return this.executorService;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

