/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.UtilityException;
import com.alee.utils.encryption.Base64;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class EncryptionUtils {
    @NotNull
    private static final String DEFAULT_ENCODING = "UTF-8";
    @NotNull
    private static final String key = "aZCVKk3mospdfm12pk4fcFD43d435ccCDgHKPQMQ23x7zkq03";

    private EncryptionUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @Nullable
    public static String encrypt(@Nullable String text) {
        return EncryptionUtils.encrypt(text, key);
    }

    @Nullable
    public static String encrypt(@Nullable String text, @NotNull String key) {
        return EncryptionUtils.base64encode(EncryptionUtils.xorText(text, key));
    }

    @Nullable
    public static String decrypt(@Nullable String text) {
        return EncryptionUtils.decrypt(text, key);
    }

    public static String decrypt(@Nullable String text, @NotNull String key) {
        return EncryptionUtils.xorText(EncryptionUtils.base64decode(text), key);
    }

    @Nullable
    public static String xorText(@Nullable String text) {
        return EncryptionUtils.xorText(text, key);
    }

    @Nullable
    public static String xorText(@Nullable String text, @NotNull String key) {
        String result;
        if (text != null) {
            char[] keys = key.toCharArray();
            char[] msg = text.toCharArray();
            int ml = msg.length;
            int kl = keys.length;
            char[] newMsg = new char[ml];
            for (int i = 0; i < ml; ++i) {
                newMsg[i] = (char)(msg[i] ^ keys[i % kl]);
            }
            result = new String(newMsg);
        } else {
            result = null;
        }
        return result;
    }

    @Nullable
    public static String base64encode(@Nullable String text) {
        try {
            return text != null ? Base64.encode(text.getBytes(DEFAULT_ENCODING)) : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to encode text using Base64", e);
        }
    }

    @Nullable
    public static String base64decode(@Nullable String text) {
        try {
            byte[] bytes = Base64.decode(text);
            return bytes != null ? new String(bytes, DEFAULT_ENCODING) : null;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to decode text using Base64", e);
        }
    }
}

