/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.UtilityException;
import com.alee.utils.laf.ShadeType;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.util.HashMap;
import java.util.Map;

public final class GraphicsUtils {
    private static final Map<String, Stroke> cachedStrokes = new HashMap<String, Stroke>();

    private GraphicsUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static Object setupAntialias(Graphics g) {
        return GraphicsUtils.setupAntialias((Graphics2D)g, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static Object setupAntialias(Graphics2D g2d) {
        return GraphicsUtils.setupAntialias(g2d, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static Object disableAntialias(Graphics g) {
        return GraphicsUtils.setupAntialias((Graphics2D)g, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static Object disableAntialias(Graphics2D g2d) {
        return GraphicsUtils.setupAntialias(g2d, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private static Object setupAntialias(Graphics2D g2d, Object aa) {
        Object old = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
        return old;
    }

    public static void restoreAntialias(Graphics g, Object old) {
        GraphicsUtils.restoreAntialias((Graphics2D)g, old);
    }

    public static void restoreAntialias(Graphics2D g2d, Object old) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
    }

    public static Composite setupAlphaComposite(Graphics2D g2d, Float alpha) {
        return GraphicsUtils.setupAlphaComposite(g2d, alpha, true);
    }

    public static Composite setupAlphaComposite(Graphics2D g2d, Float alpha, boolean shouldSetup) {
        return GraphicsUtils.setupAlphaComposite(g2d, g2d.getComposite(), alpha, shouldSetup);
    }

    public static Composite setupAlphaComposite(Graphics2D g2d, Composite composeWith, Float alpha) {
        return GraphicsUtils.setupAlphaComposite(g2d, composeWith, alpha, true);
    }

    public static Composite setupAlphaComposite(Graphics2D g2d, Composite composeWith, Float alpha, boolean shouldSetup) {
        Composite comp = g2d.getComposite();
        if (!shouldSetup || alpha == null) {
            return comp;
        }
        float currentComposite = 1.0f;
        if (composeWith != null && composeWith instanceof AlphaComposite && ((AlphaComposite)composeWith).getRule() == 3) {
            currentComposite = ((AlphaComposite)composeWith).getAlpha();
        }
        AlphaComposite newComposite = AlphaComposite.getInstance(3, currentComposite * alpha.floatValue());
        g2d.setComposite(newComposite);
        return comp;
    }

    public static void restoreComposite(Graphics2D g2d, Composite composite) {
        g2d.setComposite(composite);
    }

    public static void restoreComposite(Graphics2D g2d, Composite composite, boolean shouldRestore) {
        if (shouldRestore) {
            g2d.setComposite(composite);
        }
    }

    public static Paint setupPaint(Graphics2D g2d, Paint paint) {
        return GraphicsUtils.setupPaint(g2d, paint, true);
    }

    public static Paint setupPaint(Graphics2D g2d, Paint paint, boolean shouldSetup) {
        if (shouldSetup && paint != null) {
            Paint old = g2d.getPaint();
            g2d.setPaint(paint);
            return old;
        }
        return null;
    }

    public static void restorePaint(Graphics2D g2d, Paint paint) {
        GraphicsUtils.restorePaint(g2d, paint, true);
    }

    public static void restorePaint(Graphics2D g2d, Paint paint, boolean shouldRestore) {
        if (shouldRestore && paint != null) {
            g2d.setPaint(paint);
        }
    }

    public static Stroke setupStroke(Graphics2D g2d, Stroke stroke) {
        return GraphicsUtils.setupStroke(g2d, stroke, true);
    }

    public static Stroke setupStroke(Graphics2D g2d, Stroke stroke, boolean shouldSetup) {
        if (shouldSetup && stroke != null) {
            Stroke old = g2d.getStroke();
            g2d.setStroke(stroke);
            return old;
        }
        return null;
    }

    public static void restoreStroke(Graphics2D g2d, Stroke stroke) {
        GraphicsUtils.restoreStroke(g2d, stroke, true);
    }

    public static void restoreStroke(Graphics2D g2d, Stroke stroke, boolean shouldRestore) {
        if (shouldRestore && stroke != null) {
            g2d.setStroke(stroke);
        }
    }

    public static Shape setupClip(Graphics2D g2d, Shape clip) {
        return GraphicsUtils.setupClip(g2d, clip, true);
    }

    public static Shape setupClip(Graphics2D g2d, Shape clip, boolean shouldSetup) {
        if (shouldSetup && clip != null) {
            Shape old = g2d.getClip();
            g2d.setClip(clip);
            return old;
        }
        return null;
    }

    public static Shape setupClip(Graphics2D g2d, int x, int y, int width, int height) {
        return GraphicsUtils.setupClip(g2d, x, y, width, height, true);
    }

    public static Shape setupClip(Graphics2D g2d, int x, int y, int width, int height, boolean shouldSetup) {
        if (shouldSetup) {
            Shape old = g2d.getClip();
            g2d.setClip(x, y, width, height);
            return old;
        }
        return null;
    }

    public static void restoreClip(Graphics2D g2d, Shape clip) {
        GraphicsUtils.restoreClip(g2d, clip, true);
    }

    public static void restoreClip(Graphics2D g2d, Shape clip, boolean shouldRestore) {
        if (shouldRestore && clip != null) {
            g2d.setClip(clip);
        }
    }

    public static Object setupImageQuality(Graphics g) {
        return GraphicsUtils.setupImageQuality((Graphics2D)g);
    }

    public static Object setupImageQuality(Graphics2D g2d) {
        Object old = g2d.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        return old;
    }

    public static void restoreImageQuality(Graphics g, Object old) {
        GraphicsUtils.restoreImageQuality((Graphics2D)g, old);
    }

    public static void restoreImageQuality(Graphics2D g2d, Object old) {
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, old != null ? old : RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public static Font setupFont(Graphics g, Font font) {
        if (font != null) {
            Font oldFont = g.getFont();
            g.setFont(font);
            return oldFont;
        }
        return null;
    }

    public static void restoreFont(Graphics g, Font font) {
        if (font != null) {
            g.setFont(font);
        }
    }

    public static Shape intersectClip(Graphics2D g2d, Shape clip) {
        return GraphicsUtils.intersectClip(g2d, clip, true);
    }

    public static Shape intersectClip(Graphics2D g2d, Shape clip, boolean shouldSetup) {
        if (shouldSetup && clip != null) {
            Shape oldClip = g2d.getClip();
            g2d.clip(clip);
            return oldClip;
        }
        return null;
    }

    public static Shape subtractClip(Graphics g, Shape clip) {
        return GraphicsUtils.subtractClip(g, clip, true);
    }

    public static Shape subtractClip(Graphics g, Shape clip, boolean shouldSetup) {
        if (shouldSetup && clip != null) {
            Shape oldClip = g.getClip();
            if (oldClip != null) {
                Area finalClip = new Area(oldClip);
                finalClip.subtract(new Area(clip));
                g.setClip(finalClip);
            }
            return oldClip;
        }
        return null;
    }

    public static void restoreClip(Graphics g, Shape clip) {
        GraphicsUtils.restoreClip(g, clip, true);
    }

    public static void restoreClip(Graphics g, Shape clip, boolean shouldRestore) {
        if (shouldRestore && clip != null) {
            g.setClip(clip);
        }
    }

    public static void drawShade(Graphics2D g2d, Shape shape, Color shadeColor, int width) {
        GraphicsUtils.drawShade(g2d, shape, ShadeType.simple, shadeColor, width, null, true);
    }

    public static void drawShade(Graphics2D g2d, Shape shape, ShadeType shadeType, Color shadeColor, int width) {
        GraphicsUtils.drawShade(g2d, shape, shadeType, shadeColor, width, null, true);
    }

    public static void drawShade(Graphics2D g2d, Shape shape, ShadeType shadeType, Color shadeColor, int width, Shape clip, boolean round) {
        if (width <= 1) {
            return;
        }
        Shape oldClip = clip != null ? GraphicsUtils.intersectClip(g2d, clip) : GraphicsUtils.subtractClip(g2d, shape);
        Composite oldComposite = g2d.getComposite();
        float currentComposite = 1.0f;
        if (oldComposite instanceof AlphaComposite && ((AlphaComposite)oldComposite).getRule() == 3) {
            currentComposite = ((AlphaComposite)oldComposite).getAlpha();
        }
        Stroke oldStroke = g2d.getStroke();
        if (shadeColor != null) {
            g2d.setPaint(shadeColor);
        }
        if (shadeType.equals((Object)ShadeType.simple)) {
            float simpleShadeOpacity = 0.7f;
            g2d.setComposite(AlphaComposite.getInstance(3, 0.7f * currentComposite));
            g2d.setStroke(GraphicsUtils.getStroke(width * 2, round ? 1 : 0));
            g2d.draw(shape);
        } else {
            for (int i = width *= 2; i >= 2; i -= 2) {
                float opacity = (float)(width - i) / (float)(width - 1);
                g2d.setComposite(AlphaComposite.getInstance(3, opacity * currentComposite));
                g2d.setStroke(GraphicsUtils.getStroke(i, round ? 1 : 0));
                g2d.draw(shape);
            }
        }
        GraphicsUtils.restoreStroke(g2d, oldStroke);
        GraphicsUtils.restoreComposite(g2d, oldComposite);
        GraphicsUtils.restoreClip(g2d, oldClip);
    }

    public static Stroke getStroke(int width) {
        return GraphicsUtils.getStroke(width, 1, 1);
    }

    public static Stroke getStroke(int width, int cap) {
        return GraphicsUtils.getStroke(width, cap, 1);
    }

    public static Stroke getStroke(int width, int cap, int join) {
        String key = width + "," + cap + "," + join;
        Stroke stroke = cachedStrokes.get(key);
        if (stroke == null) {
            stroke = new BasicStroke(width, cap, join);
            cachedStrokes.put(key, stroke);
        }
        return stroke;
    }
}

