/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.utils.UtilityException;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.Tag;

public final class HtmlUtils {
    @NotNull
    public static final String DEFAULT_LINE_SEPARATOR = "\n";

    private HtmlUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @NotNull
    public static String getPlainText(@NotNull String html) {
        return HtmlUtils.getPlainText(html, DEFAULT_LINE_SEPARATOR);
    }

    @NotNull
    public static String getPlainText(@NotNull String html, @NotNull String lineSeparator) {
        String plain;
        Source source = new Source((CharSequence)html);
        Tag[] tags = source.fullSequentialParse();
        if (tags.length > 0) {
            Renderer renderer = source.getRenderer();
            renderer.setIncludeHyperlinkURLs(false);
            renderer.setIncludeAlternateText(false);
            renderer.setDecorateFontStyles(false);
            renderer.setMaxLineLength(Integer.MAX_VALUE);
            renderer.setHRLineLength(40);
            renderer.setBlockIndentSize(4);
            renderer.setConvertNonBreakingSpaces(false);
            renderer.setNewLine(lineSeparator);
            plain = renderer.toString();
        } else {
            plain = html;
        }
        return plain;
    }
}

