/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.utils.UtilityException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MapUtils {
    private MapUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static boolean isEmpty(@Nullable Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean notEmpty(@Nullable Map map) {
        return map != null && !map.isEmpty();
    }

    @NotNull
    public static <K, V> Map<K, V> nonNull(@Nullable Map<K, V> map) {
        return map != null ? map : new HashMap(0);
    }

    @NotNull
    public static <K, V> HashMap<K, V> copyMap(@NotNull Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    @NotNull
    public static <K, V> HashMap<K, V> copyHashMap(@NotNull HashMap<K, V> map) {
        return new HashMap<K, V>(map);
    }

    @NotNull
    public static <K, V> LinkedHashMap<K, V> copyLinkedHashMap(@NotNull LinkedHashMap<K, V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    @NotNull
    public static <K, V> HashMap<K, V> newHashMap(@NotNull Map<K, V> data) {
        return new HashMap<K, V>(data);
    }

    @NotNull
    public static <K, V> HashMap<K, V> newHashMap(@Nullable K key, @Nullable V value) {
        HashMap<K, V> map = new HashMap<K, V>(1);
        map.put(key, value);
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static <K, V> HashMap<K, V> newHashMap(Object ... objects) {
        if (objects == null) return new HashMap(0);
        if (objects.length <= 0) return new HashMap(0);
        if (objects.length % 2 != 0) throw new RuntimeException("Amount of key-value objects must be even");
        HashMap<Object, Object> map = new HashMap<Object, Object>(1);
        int i = 0;
        while (i < objects.length) {
            map.put(objects[i], objects[i + 1]);
            i += 2;
        }
        return map;
    }

    @NotNull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@Nullable K key, @Nullable V value) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(1);
        map.put(key, value);
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Object ... objects) {
        if (objects == null) return new LinkedHashMap(0);
        if (objects.length <= 0) return new LinkedHashMap(0);
        if (objects.length % 2 != 0) throw new RuntimeException("Amount of key-value objects must be even");
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(1);
        int i = 0;
        while (i < objects.length) {
            map.put(objects[i], objects[i + 1]);
            i += 2;
        }
        return map;
    }

    public static <K, V> void removeAllValues(@NotNull Map<K, V> map, @Nullable V value) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            if (!Objects.equals(entry.getValue(), value)) continue;
            iterator.remove();
        }
    }

    @NotNull
    public static <K, V> HashMap<K, V> merge(Map<K, V> ... maps) {
        int size = 0;
        for (Map<K, V> map : maps) {
            if (map == null) continue;
            size += map.size();
        }
        HashMap<K, V> merged = new HashMap<K, V>(size);
        for (Map<K, V> map : maps) {
            if (map == null) continue;
            merged.putAll(map);
        }
        return merged;
    }
}

