/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.UtilityException;
import java.util.Random;

public final class MathUtils {
    private static final Random random = new Random();

    private MathUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static int random() {
        return random.nextInt(101);
    }

    public static int random(int cap) {
        return random.nextInt(cap);
    }

    public static int random(int min, int max) {
        return min + random.nextInt(Math.abs(max + 1 - min));
    }

    public static int random(int ... numbers) {
        return numbers[MathUtils.random(0, numbers.length - 1)];
    }

    public static int sqr(int i) {
        return i * i;
    }

    public static float sqr(float f) {
        return f * f;
    }

    public static int sqrtToInt(double d) {
        return MathUtils.roundToInt(Math.sqrt(d));
    }

    public static int roundToInt(double d) {
        return (int)Math.round(d);
    }

    public static int limit(int min, int value, int max) {
        if (min > max) {
            throw new RuntimeException("Minimum value cannot be greated than maximum value");
        }
        return Math.max(min, Math.min(value, max));
    }

    public static long limit(long min, long value, long max) {
        if (min > max) {
            throw new RuntimeException("Minimum value cannot be greated than maximum value");
        }
        return Math.max(min, Math.min(value, max));
    }

    public static float limit(float min, float value, float max) {
        if (min > max) {
            throw new RuntimeException("Minimum value cannot be greated than maximum value");
        }
        return Math.max(min, Math.min(value, max));
    }

    public static double limit(double min, double value, double max) {
        if (min > max) {
            throw new RuntimeException("Minimum value cannot be greated than maximum value");
        }
        return Math.max(min, Math.min(value, max));
    }

    public static int max(int ... integers) {
        int max = integers[0];
        for (int i = 1; i < integers.length; ++i) {
            max = Math.max(max, integers[i]);
        }
        return max;
    }

    public static int min(int ... integers) {
        int min = integers[0];
        for (int i = 1; i < integers.length; ++i) {
            min = Math.min(min, integers[i]);
        }
        return min;
    }
}

