/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Function;
import com.alee.api.jdk.Supplier;
import com.alee.managers.language.LM;
import com.alee.utils.CollectionUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.compare.Filter;
import com.alee.utils.xml.ColorConverter;
import com.alee.utils.xml.InsetsConverter;
import com.alee.utils.xml.PointConverter;
import com.alee.utils.xml.RectangleConverter;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public final class TextUtils {
    @NotNull
    private static final List<Character> textSeparators = CollectionUtils.asList(Character.valueOf(' '), Character.valueOf('.'), Character.valueOf(','), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('/'), Character.valueOf('|'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('\\'), Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\''), Character.valueOf('\''), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('*'), Character.valueOf('%'), Character.valueOf('$'), Character.valueOf('#'), Character.valueOf('@'), Character.valueOf('!'), Character.valueOf('~'), Character.valueOf('^'), Character.valueOf('&'), Character.valueOf('?'));
    @NotNull
    private static final Function<Object, String> simpleTextProvider = new Function<Object, String>(){

        @Override
        public String apply(Object object) {
            return object != null ? object.toString() : "null";
        }
    };
    private static final int idPartLength = 5;
    @NotNull
    private static final String defaultIdPrefix = "WebLaF";
    @NotNull
    private static final String defaultIdSuffix = "ID";
    @NotNull
    private static final String defaultSeparator = ",";
    private static String systemLineSeparator;

    private TextUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @NotNull
    public static String getSystemLineSeparator() {
        if (systemLineSeparator == null) {
            try {
                systemLineSeparator = System.getProperty("line.separator");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (systemLineSeparator == null) {
                systemLineSeparator = "\n";
            }
        }
        return systemLineSeparator;
    }

    @NotNull
    public static String format(@NotNull String text, Object ... objects) {
        Object[] data = new Object[objects != null ? objects.length : 0];
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                data[i] = TextUtils.asString(objects[i]);
            }
        }
        return String.format(text, data);
    }

    @NotNull
    private static String asString(@Nullable Object object) {
        String toString;
        String string = object == null ? "null" : (object instanceof String ? (String)object : ((toString = object.toString()) != null ? toString : "null"));
        return string;
    }

    @NotNull
    public static String replace(@NotNull String text, int index, char character) {
        StringBuilder sb = new StringBuilder(text);
        sb.setCharAt(index, character);
        return sb.toString();
    }

    public static boolean equals(@Nullable String string, @Nullable String compareWith) {
        return string == compareWith || string != null && string.equals(compareWith);
    }

    public static boolean equalsIgnoreCase(@Nullable String string, @Nullable String compareWith) {
        return string == compareWith || string != null && string.equalsIgnoreCase(compareWith);
    }

    @NotNull
    public static List<String> numbered(@NotNull String pattern, int from, int to) {
        ArrayList<String> list = new ArrayList<String>(Math.abs(from - to));
        if (from < to) {
            for (int i = from; i <= to; ++i) {
                list.add(TextUtils.format(pattern, i));
            }
        } else {
            for (int i = from; i >= to; --i) {
                list.add(TextUtils.format(pattern, i));
            }
        }
        return list;
    }

    @NotNull
    public static String removeLineBreaks(@NotNull String text) {
        return text.replaceAll("\\r\\n|\\r|\\n", "");
    }

    @NotNull
    public static String removeSpacings(@NotNull String text) {
        return text.replaceAll("[ \\t]", "");
    }

    @NotNull
    public static Integer findFirstNumber(@NotNull String text) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < text.length(); ++j) {
            char ch = text.charAt(j);
            if (Character.isDigit(ch)) {
                sb.append(ch);
                continue;
            }
            if (sb.length() > 0) break;
        }
        return Integer.parseInt(sb.toString());
    }

    @Nullable
    public static String getWord(@NotNull String text, int location) {
        String word;
        if (0 <= location && location < text.length()) {
            if (!textSeparators.contains(Character.valueOf(text.charAt(location)))) {
                int wordEnd;
                int wordStart = location;
                for (wordEnd = location; wordEnd < text.length() - 1 && !textSeparators.contains(Character.valueOf(text.charAt(wordEnd))); ++wordEnd) {
                }
                while (wordStart > 0 && !textSeparators.contains(Character.valueOf(text.charAt(wordStart - 1)))) {
                    --wordStart;
                }
                word = wordStart == wordEnd ? null : text.substring(wordStart, wordEnd);
            } else {
                word = null;
            }
        } else {
            word = null;
        }
        return word;
    }

    public static int getWordStart(@NotNull String text, int location) {
        int start;
        if (0 <= location && location < text.length()) {
            if (!textSeparators.contains(Character.valueOf(text.charAt(location)))) {
                int wordStart;
                for (wordStart = location; wordStart > 0 && !textSeparators.contains(Character.valueOf(text.charAt(wordStart - 1))); --wordStart) {
                }
                start = wordStart;
            } else {
                start = -1;
            }
        } else {
            start = -1;
        }
        return start;
    }

    public static int getWordEnd(@NotNull String text, int location) {
        int end;
        if (0 <= location && location < text.length()) {
            if (!textSeparators.contains(Character.valueOf(text.charAt(location)))) {
                int wordEnd;
                for (wordEnd = location; wordEnd < text.length() && !textSeparators.contains(Character.valueOf(text.charAt(wordEnd))); ++wordEnd) {
                }
                end = wordEnd;
            } else {
                end = -1;
            }
        } else {
            end = -1;
        }
        return end;
    }

    public static int findLastRowWordStartIndex(@NotNull String string) {
        int index = -1;
        boolean spaceFound = false;
        boolean skipSpace = true;
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (!spaceFound && !skipSpace) {
                if (c != ' ' && c != '\t' && c != '\r' && c != '\n') continue;
                spaceFound = true;
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            if (spaceFound) {
                index = i;
                break;
            }
            skipSpace = false;
        }
        return index;
    }

    public static int findFirstWordFromIndex(@NotNull String string, int from) {
        int index = -1;
        for (int i = from; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            index = i;
            break;
        }
        return index;
    }

    public static int findFirstRowWordEndIndex(@NotNull String string) {
        int index = string.length();
        boolean spaceFound = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!spaceFound) {
                if (c != ' ' && c != '\t' && c != '\r' && c != '\n') continue;
                spaceFound = true;
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            index = i;
            break;
        }
        return index;
    }

    @NotNull
    public static String removeFirstLines(@NotNull String text, int count) {
        int index = 0;
        for (int found = 0; found < count && (index = text.indexOf("\n", index)) != -1; ++found) {
            ++index;
        }
        return index != -1 ? text.substring(index) : "";
    }

    @Nullable
    public static Point parsePoint(@NotNull String text) {
        return TextUtils.parsePoint(text, defaultSeparator);
    }

    @Nullable
    public static Point parsePoint(@NotNull String text, @NotNull String separator) {
        String[] parts = text.split(separator);
        return parts.length == 2 ? new Point(Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim())) : null;
    }

    @NotNull
    public static String shortenText(@NotNull String text, int maxLength, boolean addDots) {
        return text.length() <= maxLength ? text : text.substring(0, maxLength > 3 && addDots ? maxLength - 3 : maxLength) + (addDots ? "..." : "");
    }

    @NotNull
    public static String shortenTextEnd(@NotNull String text, int maxLength, boolean addDots) {
        return text.length() <= maxLength ? text : (addDots ? "..." : "") + text.substring(text.length() - (maxLength > 3 && addDots ? maxLength - 3 : maxLength));
    }

    @NotNull
    public static List<String> stringToList(@Nullable String string) {
        return TextUtils.stringToList(string, defaultSeparator);
    }

    @NotNull
    public static List<String> stringToList(@Nullable String string, @NotNull String separator) {
        ArrayList<String> strings = new ArrayList<String>();
        if (string != null) {
            StringTokenizer tokenizer = new StringTokenizer(string, separator, false);
            while (tokenizer.hasMoreTokens()) {
                strings.add(tokenizer.nextToken().trim());
            }
        }
        return strings;
    }

    @NotNull
    public static List<Integer> stringToIntList(@Nullable String string) {
        return TextUtils.stringToIntList(string, defaultSeparator);
    }

    @NotNull
    public static List<Integer> stringToIntList(@Nullable String string, @NotNull String separator) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        if (string != null) {
            StringTokenizer tokenizer = new StringTokenizer(string, separator, false);
            while (tokenizer.hasMoreTokens()) {
                intList.add(Integer.parseInt(tokenizer.nextToken().trim()));
            }
        }
        return intList;
    }

    @NotNull
    public static List<Float> stringToFloatList(@Nullable String string) {
        return TextUtils.stringToFloatList(string, defaultSeparator);
    }

    @NotNull
    public static List<Float> stringToFloatList(@Nullable String string, @NotNull String separator) {
        ArrayList<Float> floatList = new ArrayList<Float>();
        if (string != null) {
            StringTokenizer tokenizer = new StringTokenizer(string, separator, false);
            while (tokenizer.hasMoreTokens()) {
                floatList.add(Float.valueOf(Float.parseFloat(tokenizer.nextToken().trim())));
            }
        }
        return floatList;
    }

    @Nullable
    public static <T> String listToString(@Nullable List<T> list) {
        return TextUtils.listToString(list, defaultSeparator, simpleTextProvider, null);
    }

    @Nullable
    public static <T> String listToString(@Nullable List<T> list, @NotNull String separator) {
        return TextUtils.listToString(list, separator, simpleTextProvider, null);
    }

    @Nullable
    public static <T> String listToString(@Nullable List<T> list, @NotNull String separator, @NotNull Function<T, String> textProvider) {
        return TextUtils.listToString(list, separator, textProvider, null);
    }

    @Nullable
    public static <T> String listToString(@Nullable List<T> list, @NotNull String separator, @NotNull Function<T, String> textProvider, @Nullable Filter<T> filter) {
        String result;
        if (CollectionUtils.notEmpty(list)) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean hasPreviouslyAccepted = false;
            for (T object : list) {
                if (filter != null && !filter.accept(object)) continue;
                if (hasPreviouslyAccepted) {
                    stringBuilder.append(separator);
                }
                stringBuilder.append(textProvider.apply(object));
                hasPreviouslyAccepted = true;
            }
            result = stringBuilder.toString();
        } else {
            result = null;
        }
        return result;
    }

    @Nullable
    public static <T> String collectionToString(@Nullable Collection<T> collection) {
        return TextUtils.collectionToString(collection, defaultSeparator, simpleTextProvider, null);
    }

    @Nullable
    public static <T> String collectionToString(@Nullable Collection<T> collection, @NotNull String separator) {
        return TextUtils.collectionToString(collection, separator, simpleTextProvider, null);
    }

    @Nullable
    public static <T> String collectionToString(@Nullable Collection<T> collection, @NotNull String separator, @NotNull Function<T, String> textProvider) {
        return TextUtils.collectionToString(collection, separator, textProvider, null);
    }

    @Nullable
    public static <T> String collectionToString(@Nullable Collection<T> collection, @NotNull String separator, @NotNull Function<T, String> textProvider, @Nullable Filter<T> filter) {
        String result;
        if (CollectionUtils.notEmpty(collection)) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean hasPreviouslyAccepted = false;
            for (T object : collection) {
                if (filter != null && !filter.accept(object)) continue;
                if (hasPreviouslyAccepted) {
                    stringBuilder.append(separator);
                }
                stringBuilder.append(textProvider.apply(object));
                hasPreviouslyAccepted = true;
            }
            result = stringBuilder.toString();
        } else {
            result = null;
        }
        return result;
    }

    @Nullable
    public static <T> String arrayToString(T ... array) {
        return TextUtils.arrayToString(defaultSeparator, simpleTextProvider, null, array);
    }

    @Nullable
    public static <T> String arrayToString(@NotNull String separator, T ... array) {
        return TextUtils.arrayToString(separator, simpleTextProvider, null, array);
    }

    @Nullable
    public static <T> String arrayToString(@NotNull String separator, @NotNull Function<T, String> textProvider, T ... array) {
        return TextUtils.arrayToString(separator, textProvider, null, array);
    }

    @Nullable
    public static <T> String arrayToString(@NotNull String separator, @NotNull Function<T, String> textProvider, @Nullable Filter<T> filter, T ... array) {
        String result;
        if (array != null && array.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean hasPreviouslyAccepted = false;
            for (T object : array) {
                if (filter != null && !filter.accept(object)) continue;
                if (hasPreviouslyAccepted) {
                    stringBuilder.append(separator);
                }
                stringBuilder.append(textProvider.apply(object));
                hasPreviouslyAccepted = true;
            }
            result = stringBuilder.toString();
        } else {
            result = null;
        }
        return result;
    }

    @Nullable
    public static <E extends Enum<E>> String enumArrayToString(E ... enumArray) {
        return TextUtils.enumArrayToString((String)defaultSeparator, enumArray);
    }

    @Nullable
    public static <E extends Enum<E>> String enumArrayToString(@NotNull String separator, E ... enumArray) {
        String result;
        if (enumArray != null && enumArray.length > 0) {
            int end = enumArray.length - 1;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i <= end; ++i) {
                stringBuilder.append(enumArray[i]);
                stringBuilder.append(i != end ? separator : "");
            }
            result = stringBuilder.toString();
        } else {
            result = null;
        }
        return result;
    }

    @Nullable
    public static <E extends Enum<E>> String enumListToString(@Nullable List<E> enumList) {
        return TextUtils.enumListToString(enumList, defaultSeparator);
    }

    @Nullable
    public static <E extends Enum<E>> String enumListToString(@Nullable List<E> enumList, @NotNull String separator) {
        String result;
        if (enumList != null && enumList.size() > 0) {
            int end = enumList.size() - 1;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i <= end; ++i) {
                stringBuilder.append(enumList.get(i));
                stringBuilder.append(i != end ? separator : "");
            }
            result = stringBuilder.toString();
        } else {
            result = null;
        }
        return result;
    }

    @NotNull
    public static <E extends Enum<E>> List<E> enumStringToList(@Nullable String enumString, @NotNull Class<E> enumClass) {
        return TextUtils.enumStringToList(enumString, enumClass, defaultSeparator);
    }

    @NotNull
    public static <E extends Enum<E>> List<E> enumStringToList(@Nullable String enumString, @NotNull Class<E> enumClass, @NotNull String separator) {
        ArrayList<E> enumerations;
        if (enumString != null) {
            StringTokenizer tokenizer = new StringTokenizer(enumString, separator, false);
            enumerations = new ArrayList();
            while (tokenizer.hasMoreTokens()) {
                enumerations.add(Enum.valueOf(enumClass, tokenizer.nextToken().trim()));
            }
        } else {
            enumerations = new ArrayList<E>(0);
        }
        return enumerations;
    }

    @NotNull
    public static String unite(@NotNull String separator, String ... parts) {
        String result;
        if (parts != null && parts.length > 0) {
            StringBuilder sb = new StringBuilder();
            boolean hasPrevious = false;
            for (String part : parts) {
                if (TextUtils.isEmpty(part)) continue;
                if (hasPrevious) {
                    sb.append(separator);
                }
                sb.append(part);
                hasPrevious = true;
            }
            result = sb.toString();
        } else {
            result = "";
        }
        return result;
    }

    public static int length(@Nullable String text) {
        return text != null ? text.length() : 0;
    }

    public static boolean isEmpty(@Nullable String text) {
        return text == null || text.isEmpty();
    }

    public static boolean notEmpty(@Nullable String text) {
        return !TextUtils.isEmpty(text);
    }

    public static boolean isBlank(@Nullable String text) {
        return text == null || text.isEmpty() || TextUtils.removeLineBreaks(text).trim().isEmpty();
    }

    public static boolean notBlank(@Nullable String text) {
        return !TextUtils.isBlank(text);
    }

    @NotNull
    public static String requireNonEmpty(@Nullable String text) {
        return TextUtils.requireNonEmpty(text, "Text must not be empty");
    }

    @NotNull
    public static String requireNonEmpty(@Nullable String text, @NotNull String message) {
        if (TextUtils.isEmpty(text)) {
            throw new NullPointerException(LM.contains(message) ? LM.get(message, new Object[0]) : message);
        }
        return text;
    }

    @NotNull
    public static String requireNonEmpty(@Nullable String text, @NotNull Supplier<RuntimeException> exceptionSupplier) {
        if (TextUtils.isEmpty(text)) {
            throw exceptionSupplier.get();
        }
        return text;
    }

    @NotNull
    public static String createString(@NotNull String character, int length) {
        return TextUtils.createString(character.charAt(0), length);
    }

    @NotNull
    public static String createString(char character, int length) {
        char[] characters = new char[length];
        Arrays.fill(characters, character);
        return new String(characters);
    }

    @NotNull
    public static String replaceAll(@NotNull String text, boolean ignoreCase, @NotNull String str, @NotNull Function<String, String> replacer) {
        String exp = ignoreCase ? str.toLowerCase(Locale.ROOT) : str;
        int match = 0;
        int prev = 0;
        StringBuilder builder = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            match = exp.charAt(match) == (ignoreCase ? Character.toLowerCase(ch) : ch) ? ++match : (exp.charAt(0) == (ignoreCase ? Character.toLowerCase(ch) : ch) ? 1 : 0);
            if (match == exp.length()) {
                int start = i - exp.length() + 1;
                String part = text.substring(start, start + exp.length());
                builder.append(text, prev, start);
                builder.append(replacer.apply(part));
                prev = start + exp.length();
                match = 0;
                continue;
            }
            if (i != text.length() - 1) continue;
            builder.append(text.substring(prev));
        }
        return builder.toString();
    }

    @NotNull
    public static String generateId() {
        return TextUtils.generateId(null, null);
    }

    @NotNull
    public static String generateId(@Nullable String prefix) {
        return TextUtils.generateId(prefix, null);
    }

    @NotNull
    public static String generateId(@Nullable String prefix, @Nullable String suffix) {
        return (prefix == null ? defaultIdPrefix : prefix) + "-" + TextUtils.generateId(5) + "-" + TextUtils.generateId(5) + "-" + TextUtils.generateId(5) + "-" + TextUtils.generateId(5) + "-" + (suffix == null ? defaultIdSuffix : suffix);
    }

    @NotNull
    public static String generateId(int length) {
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int next = 0;
            int range = 10;
            switch (MathUtils.random(3)) {
                case 0: {
                    next = 48;
                    range = 10;
                    break;
                }
                case 1: {
                    next = 97;
                    range = 26;
                    break;
                }
                case 2: {
                    next = 65;
                    range = 26;
                }
            }
            stringBuilder.append((char)(MathUtils.random(range) + next));
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static String getSettingsKey(Object ... settings) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : settings) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            if (object != null) {
                if (object.getClass().isArray()) {
                    int length = Array.getLength(object);
                    for (int i = 0; i < length; ++i) {
                        if (i > 0) {
                            stringBuilder.append(";");
                        }
                        stringBuilder.append(TextUtils.getSettingsKey(Array.get(object, i)));
                    }
                    continue;
                }
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    stringBuilder.append(TextUtils.getSettingsKey(collection.toArray()));
                    continue;
                }
                stringBuilder.append(TextUtils.getSettingKey(object));
                continue;
            }
            stringBuilder.append(TextUtils.getSettingKey(null));
        }
        return stringBuilder.toString();
    }

    @NotNull
    private static String getSettingKey(@Nullable Object setting) {
        String toString;
        String key = setting == null ? "null" : (setting instanceof Insets ? InsetsConverter.insetsToString((Insets)setting) : (setting instanceof Rectangle ? RectangleConverter.rectangleToString((Rectangle)setting) : (setting instanceof Point ? PointConverter.pointToString((Point)setting) : (setting instanceof Color ? ColorConverter.colorToString((Color)setting) : ((toString = setting.toString()) != null ? toString : "null")))));
        return key;
    }
}

