/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.jar;

import com.alee.api.Identifiable;
import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.jar.JarEntryComparator;
import com.alee.utils.jar.JarEntryType;
import com.alee.utils.jar.JarStructure;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;

public class JarEntry
implements Identifiable {
    protected static final String ID_PREFIX = "JE";
    @NotNull
    protected final String id = TextUtils.generateId("JE");
    @NotNull
    protected final JarStructure structure;
    @Nullable
    protected final JarEntry parent;
    @Nullable
    protected final ZipEntry zipEntry;
    @NotNull
    protected final JarEntryType type;
    @NotNull
    protected String name;
    @Nullable
    protected Icon icon;
    @Nullable
    protected List<JarEntry> children;

    public JarEntry(@NotNull JarStructure structure, @NotNull JarEntryType type, @NotNull String name) {
        this(structure, null, null, type, name);
    }

    public JarEntry(@NotNull JarStructure structure, @Nullable JarEntry parent, @Nullable ZipEntry zipEntry, @NotNull JarEntryType type, @NotNull String name) {
        this.structure = structure;
        this.parent = parent;
        this.zipEntry = zipEntry;
        this.children = null;
        this.type = type;
        this.name = name;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public JarEntry getParent() {
        return this.parent;
    }

    @Nullable
    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    @NotNull
    public JarEntryType getType() {
        return this.type;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public Icon getIcon() {
        Icon standard;
        Icon icon = this.icon != null ? this.icon : (this.type != JarEntryType.FILE ? this.type.getIcon() : ((standard = FileUtils.getStandardFileIcon(false, this.getEntryExtension(), 1.0f)) != null ? standard : JarEntryType.FILE.getIcon()));
        return icon;
    }

    public void setIcon(@Nullable Icon icon) {
        this.icon = icon;
    }

    @NotNull
    public List<JarEntry> getChildren() {
        return this.children != null ? new ArrayList<JarEntry>(this.children) : new ArrayList();
    }

    @NotNull
    public JarEntry getChildByName(@Nullable String name) {
        return this.getChildByName(name, false);
    }

    @NotNull
    public JarEntry getChildByName(@Nullable String name, boolean recursively) {
        JarEntry child = this.findChildByName(name, recursively);
        if (child == null) {
            throw new UtilityException("Cannot find child by name: " + name);
        }
        return child;
    }

    @Nullable
    public JarEntry findChildByName(@Nullable String name) {
        return this.findChildByName(name, false);
    }

    @Nullable
    public JarEntry findChildByName(@Nullable String name, boolean recursively) {
        JarEntry childByName = null;
        if (this.children != null) {
            for (JarEntry child : this.children) {
                JarEntry otherChild;
                if (child.getName().equals(name)) {
                    childByName = child;
                    break;
                }
                if (!recursively || (otherChild = child.findChildByName(name, true)) == null) continue;
                childByName = child;
                break;
            }
        }
        return childByName;
    }

    public void addChild(@NotNull JarEntry child) {
        if (this.children == null) {
            this.children = new ArrayList<JarEntry>();
        }
        this.children.add(child);
        CollectionUtils.sort(this.children, JarEntryComparator.instance());
    }

    public void removeChild(@NotNull JarEntry child) {
        if (this.children != null) {
            this.children.remove(child);
        }
    }

    @NotNull
    public String getEntryExtension() {
        return FileUtils.getFileExtPart(this.name, false);
    }

    public boolean isClassEntry(@Nullable Class classType) {
        return classType != null && classType.getCanonicalName().equals(this.getCanonicalEntryName());
    }

    @NotNull
    public String getCanonicalEntryName() {
        StringBuilder canonicalName = new StringBuilder(this.getName());
        for (JarEntry parent = this.getParent(); parent != null && !parent.getType().equals((Object)JarEntryType.JAR); parent = parent.getParent()) {
            canonicalName.insert(0, parent.getName() + ".");
        }
        if (this.type.equals((Object)JarEntryType.CLASS) || this.type.equals((Object)JarEntryType.JAVA)) {
            canonicalName = new StringBuilder(canonicalName.substring(0, canonicalName.lastIndexOf(".")));
        }
        return canonicalName.toString();
    }

    @NotNull
    public String getCanonicalEntryPath() {
        StringBuilder canonicalName = new StringBuilder(this.getName());
        for (JarEntry parent = this.getParent(); parent != null && !parent.getType().equals((Object)JarEntryType.JAR) && parent.getParent() != null && !parent.getParent().getType().equals((Object)JarEntryType.JAR); parent = parent.getParent()) {
            canonicalName.insert(0, parent.getName() + "/");
        }
        return canonicalName.toString();
    }

    @NotNull
    public List<JarEntry> getPath() {
        ArrayList<JarEntry> path = new ArrayList<JarEntry>();
        for (JarEntry current = this; current != null && !current.getType().equals((Object)JarEntryType.JAR); current = current.getParent()) {
            path.add(0, current);
        }
        return path;
    }

    @NotNull
    public InputStream getInputStream() {
        ZipEntry zipEntry = this.getZipEntry();
        if (zipEntry != null) {
            try {
                return new ZipFile(this.structure.getJarLocation()).getInputStream(zipEntry);
            }
            catch (IOException e) {
                throw new UtilityException("Unable to open InputStream for JarEntry: " + this.getName(), e);
            }
        }
        throw new UtilityException("JarEntry of JAR type cannot be read");
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof JarEntry && ((JarEntry)other).getCanonicalEntryPath().equals(this.getCanonicalEntryPath());
    }

    @NotNull
    public String toString() {
        return this.getName() + " (" + (Object)((Object)this.getType()) + ")";
    }
}

