/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.reflection;

public enum ClassRelationType {
    SAME,
    ANCESTOR,
    DESCENDANT,
    UNRELATED;


    public boolean isSame() {
        return this == SAME;
    }

    public boolean isAncestor() {
        return this == ANCESTOR;
    }

    public boolean isDescendant() {
        return this == DESCENDANT;
    }

    public boolean isUnrelated() {
        return this == UNRELATED;
    }

    public boolean isRelated() {
        return this != UNRELATED;
    }

    public static ClassRelationType of(Object one, Object another) {
        return ClassRelationType.of(one.getClass(), another.getClass());
    }

    public static ClassRelationType of(Class one, Class another) {
        if (one == another) {
            return SAME;
        }
        if (one.isAssignableFrom(another)) {
            return DESCENDANT;
        }
        if (another.isAssignableFrom(one)) {
            return ANCESTOR;
        }
        return UNRELATED;
    }
}

