/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.reflection;

import com.alee.utils.ReflectUtils;
import com.alee.utils.reflection.ReflectionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.WeakHashMap;

public final class Unsafe {
    private static Map<Class, byte[]> serializedDataCache;

    public static <T> T allocateInstance(Class<T> clazz) {
        if (clazz != null) {
            T instance;
            block8: {
                try {
                    instance = Unsafe.allocateInstanceThroughUnsafe(clazz);
                }
                catch (Exception e) {
                    try {
                        instance = Unsafe.allocateInstanceThroughReflection(clazz);
                    }
                    catch (Exception ex) {
                        if (Serializable.class.isAssignableFrom(clazz)) {
                            try {
                                instance = Unsafe.allocateInstanceThroughSerialization(clazz);
                                break block8;
                            }
                            catch (Exception exx) {
                                throw new ReflectionException("Unable to instantiate class: " + clazz, ex);
                            }
                        }
                        throw new ReflectionException("Unable to instantiate class: " + clazz, ex);
                    }
                }
            }
            return instance;
        }
        throw new ReflectionException("Class type must not be null");
    }

    private static <T> T allocateInstanceThroughUnsafe(Class<T> clazz) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class unsafe = ReflectUtils.getClass("sun.misc.Unsafe");
        Object theUnsafe = ReflectUtils.getStaticFieldValue(unsafe, "theUnsafe");
        return ReflectUtils.callMethod(theUnsafe, "allocateInstance", clazz);
    }

    private static <T> T allocateInstanceThroughReflection(Class<T> clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return ReflectUtils.createInstance(clazz, new Object[0]);
    }

    private static synchronized <T> T allocateInstanceThroughSerialization(final Class<T> clazz) throws IOException, ClassNotFoundException {
        byte[] data;
        if (serializedDataCache == null) {
            serializedDataCache = new WeakHashMap<Class, byte[]>();
        }
        if ((data = serializedDataCache.get(clazz)) == null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bytes);
            stream.writeShort(-21267);
            stream.writeShort(5);
            stream.writeByte(115);
            stream.writeByte(114);
            stream.writeUTF(clazz.getName());
            stream.writeLong(ObjectStreamClass.lookup(clazz).getSerialVersionUID());
            stream.writeByte(2);
            stream.writeShort(0);
            stream.writeByte(120);
            stream.writeByte(112);
            data = bytes.toByteArray();
            serializedDataCache.put(clazz, data);
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data)){

            protected Class resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                return Class.forName(desc.getName(), false, clazz.getClassLoader());
            }
        };
        return (T)in.readObject();
    }
}

