/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.sort;

import com.alee.utils.sort.TopologicalGraphProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class TopologicalSorter<T> {
    private final TopologicalGraphProvider<T> provider;

    public TopologicalSorter(TopologicalGraphProvider<T> provider) {
        this.provider = provider;
    }

    public List<T> list() {
        ArrayList<Node<T>> nodes = new ArrayList<Node<T>>();
        HashMap nodesCache = new HashMap();
        for (T root : this.provider.getRoots()) {
            this.buildNodeStructure(root, nodes, nodesCache);
        }
        List<Node<T>> sortedNodes = this.doTopologicalSort(nodes);
        ArrayList sortedData = new ArrayList(sortedNodes.size());
        for (Node<T> node : sortedNodes) {
            sortedData.add(node.data);
        }
        return sortedData;
    }

    private Node<T> buildNodeStructure(T data, List<Node<T>> nodes, Map<T, Node<T>> nodesCache) {
        Node<T> node;
        if (nodesCache.containsKey(data)) {
            node = nodesCache.get(data);
        } else {
            node = new Node<T>(data);
            nodes.add(node);
            nodesCache.put(data, node);
            for (T child : this.provider.getChildren(data)) {
                node.addEdge(this.buildNodeStructure(child, nodes, nodesCache));
            }
        }
        return node;
    }

    private List<Node<T>> doTopologicalSort(List<Node<T>> nodes) {
        ArrayList<Node<T>> L = new ArrayList<Node<T>>();
        HashSet S = new HashSet();
        for (Node<T> n : nodes) {
            if (n.inEdges.size() != 0) continue;
            S.add(n);
        }
        while (!S.isEmpty()) {
            Node n = (Node)S.iterator().next();
            S.remove(n);
            L.add(n);
            Iterator it = n.outEdges.iterator();
            while (it.hasNext()) {
                Edge e = it.next();
                Node m = e.to;
                it.remove();
                m.inEdges.remove(e);
                if (!m.inEdges.isEmpty()) continue;
                S.add(m);
            }
        }
        boolean cycle = false;
        for (Node<T> n : nodes) {
            if (n.inEdges.isEmpty()) continue;
            cycle = true;
            break;
        }
        if (!cycle) {
            return L;
        }
        throw new RuntimeException("Cycle present, topological sort not possible");
    }

    private static class Edge<T> {
        public final Node<T> from;
        public final Node<T> to;

        public Edge(Node<T> from, Node<T> to) {
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object object) {
            if (object instanceof Edge) {
                Edge edge = (Edge)object;
                return edge.from == this.from && edge.to == this.to;
            }
            return false;
        }
    }

    private static class Node<T> {
        public final T data;
        public final HashSet<Edge<T>> inEdges;
        public final HashSet<Edge<T>> outEdges;

        public Node(T data) {
            this.data = data;
            this.inEdges = new HashSet();
            this.outEdges = new HashSet();
        }

        public Node addEdge(Node<T> node) {
            Edge<T> edge = new Edge<T>(this, node);
            this.outEdges.add(edge);
            node.inEdges.add(edge);
            return this;
        }

        public String toString() {
            return this.data != null ? this.data.toString() : null;
        }
    }
}

