/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.BiFunction;
import com.alee.api.jdk.BiPredicate;
import com.alee.api.jdk.Function;
import com.alee.utils.collection.ImmutableSet;
import com.alee.utils.collection.WeakHashSet;
import java.util.Set;
import javax.swing.JComponent;

public class WeakComponentData<C extends JComponent, D> {
    @NotNull
    protected final String key;
    @NotNull
    protected final Set<C> components;

    public WeakComponentData(@NotNull String key, int initialCapacity) {
        this.key = key;
        this.components = new WeakHashSet<C>(initialCapacity);
    }

    @NotNull
    public synchronized Set<C> components() {
        return new ImmutableSet<C>(this.components);
    }

    public synchronized int size() {
        return this.components.size();
    }

    public synchronized boolean contains(@NotNull C component) {
        return this.components.contains(component);
    }

    @Nullable
    public synchronized D get(@NotNull C component) {
        return (D)((JComponent)component).getClientProperty(this.key);
    }

    @NotNull
    public synchronized D get(@NotNull C component, @NotNull Function<C, D> defaultData) {
        D data = this.get(component);
        if (data == null) {
            data = defaultData.apply(component);
            this.set(component, data);
        }
        return data;
    }

    @NotNull
    public synchronized D modify(@NotNull C component, @NotNull BiFunction<C, D, D> modifiedData, @NotNull Function<C, D> defaultData) {
        D data = this.get(component);
        if (data == null) {
            data = defaultData.apply(component);
            this.set(component, data);
        } else {
            data = modifiedData.apply(component, data);
            this.set(component, data);
        }
        return data;
    }

    @Nullable
    public synchronized D set(@NotNull C component, @Nullable D data) {
        D oldData = this.get(component);
        if (data != null) {
            ((JComponent)component).putClientProperty(this.key, data);
            this.components.add(component);
        } else {
            this.clear(component);
        }
        return oldData;
    }

    @Nullable
    public synchronized D set(@NotNull C component, @Nullable D data, @NotNull BiConsumer<C, D> oldDataConsumer) {
        D oldData;
        if (this.contains(component)) {
            oldData = this.get(component);
            oldDataConsumer.accept(component, this.get(component));
        } else {
            oldData = null;
        }
        if (data != null) {
            this.set(component, data);
        } else {
            this.clear(component, oldDataConsumer);
        }
        return oldData;
    }

    @Nullable
    public synchronized D clear(@NotNull C component) {
        D oldData = this.get(component);
        ((JComponent)component).putClientProperty(this.key, null);
        this.components.remove(component);
        return oldData;
    }

    @Nullable
    public synchronized D clear(@NotNull C component, @NotNull BiConsumer<C, D> removedDataConsumer) {
        Object oldData;
        if (this.contains(component)) {
            oldData = this.get(component);
            removedDataConsumer.accept(component, oldData);
            this.clear(component);
        } else {
            oldData = null;
        }
        return (D)oldData;
    }

    public synchronized void forEach(@NotNull BiConsumer<C, D> consumer) {
        for (JComponent component : this.components()) {
            D data = this.get(component);
            consumer.accept(component, data);
        }
    }

    public synchronized boolean anyMatch(@NotNull BiPredicate<C, D> predicate) {
        boolean anyMatch = false;
        for (JComponent component : this.components()) {
            if (!predicate.test(component, this.get(component))) continue;
            anyMatch = true;
            break;
        }
        return anyMatch;
    }

    public synchronized boolean allMatch(@NotNull BiPredicate<C, D> predicate) {
        boolean allMatch = true;
        for (JComponent component : this.components()) {
            if (predicate.test(component, this.get(component))) continue;
            allMatch = false;
            break;
        }
        return allMatch;
    }

    public synchronized boolean noneMatch(@NotNull BiPredicate<C, D> predicate) {
        boolean noneMatch = true;
        for (JComponent component : this.components()) {
            if (!predicate.test(component, this.get(component))) continue;
            noneMatch = false;
            break;
        }
        return noneMatch;
    }
}

