/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.utils.ColorUtils;
import com.alee.utils.MapUtils;
import com.alee.utils.swing.ColorUIResource;
import com.alee.utils.xml.ConverterContext;
import com.alee.utils.xml.XmlException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Color;
import java.util.Map;

public class ColorConverter
extends AbstractSingleValueConverter {
    public static final String NULL_COLOR = "null";
    public static final String NONE_COLOR = "none";
    private static final Map<String, Color> defaultColors = MapUtils.newHashMap("null", null, "none", null, "transparent", ColorUtils.transparent(), "black", Color.BLACK, "white", Color.WHITE, "red", Color.RED, "green", Color.GREEN, "blue", Color.BLUE, "lightGray", Color.LIGHT_GRAY, "gray", Color.GRAY, "darkGray", Color.DARK_GRAY, "pink", Color.PINK, "orange", Color.ORANGE, "yellow", Color.YELLOW, "magenta", Color.MAGENTA, "cyan", Color.CYAN);

    public boolean canConvert(@NotNull Class type) {
        return Color.class.isAssignableFrom(type);
    }

    @Nullable
    public String toString(@Nullable Object color) {
        return ColorConverter.colorToString((Color)color);
    }

    @Nullable
    public Object fromString(@Nullable String string) {
        Color color = ColorConverter.colorFromString(string);
        return color != null && ConverterContext.get().isUIResource() ? new ColorUIResource(color) : color;
    }

    @NotNull
    public static String colorToString(@Nullable Color color) {
        String string = null;
        if (color == null) {
            string = NULL_COLOR;
        } else if (defaultColors.containsValue(color)) {
            for (Map.Entry<String, Color> entry : defaultColors.entrySet()) {
                if (!Objects.equals((Object)color, (Object)entry.getValue())) continue;
                string = entry.getKey();
                break;
            }
            if (string == null) {
                throw new RuntimeException("Unable to find mapping for Color: " + color);
            }
        } else {
            StringBuilder builder = new StringBuilder(15);
            builder.append(color.getRed()).append(",");
            builder.append(color.getGreen()).append(",");
            builder.append(color.getBlue());
            if (color.getAlpha() < 255) {
                builder.append(",").append(color.getAlpha());
            }
            string = builder.toString();
        }
        return string;
    }

    @Nullable
    public static Color colorFromString(@Nullable String string) {
        try {
            Color color = string == null ? null : (defaultColors.containsKey(string) ? defaultColors.get(string) : (string.contains("#") ? ColorUtils.fromHex(string) : ColorUtils.fromRGBA(string)));
            return color;
        }
        catch (Exception e) {
            throw new XmlException("Unable to parse Color: " + string, e);
        }
    }
}

