/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.utils.TextUtils;
import com.alee.utils.xml.XmlException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.geom.Point2D;
import java.util.List;

public class Point2DConverter
extends AbstractSingleValueConverter {
    public boolean canConvert(Class type) {
        return Point2D.class.isAssignableFrom(type);
    }

    public String toString(Object obj) {
        return Point2DConverter.pointToString((Point2D)obj);
    }

    public Object fromString(String str) {
        return Point2DConverter.pointFromString(str);
    }

    public static String pointToString(Point2D point) {
        return point.getX() + "," + point.getY();
    }

    public static Point2D.Float pointFromString(String point) {
        try {
            List<String> points = TextUtils.stringToList(point, ",");
            float x = Float.parseFloat(points.get(0));
            float y = Float.parseFloat(points.get(1));
            return new Point2D.Float(x, y);
        }
        catch (Exception e) {
            throw new XmlException("Unable to parse Point2D: " + point, e);
        }
    }
}

