/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.utils.TextUtils;
import com.alee.utils.xml.ColorConverter;
import com.alee.utils.xml.InsetsConverter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.awt.Color;
import java.awt.Insets;
import java.lang.reflect.Array;
import java.util.List;

public class SimpleArrayConverter
extends AbstractCollectionConverter {
    private static final String separator = ";";

    public SimpleArrayConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return type.isArray();
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        int length = Array.getLength(object);
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(object, i);
            if (item == null) {
                throw new IllegalArgumentException("This converter doesn't support null array elements");
            }
            if (item.getClass().isPrimitive() || item instanceof Integer || item instanceof Character || item instanceof Byte || item instanceof Short || item instanceof Long || item instanceof Float || item instanceof Double) {
                value.append(item.toString());
            } else if (item instanceof Color) {
                value.append(ColorConverter.colorToString((Color)item));
            } else if (item instanceof Insets) {
                value.append(InsetsConverter.insetsToString((Insets)item));
            } else {
                throw new IllegalArgumentException("Unable to marshal array of type: " + item.getClass());
            }
            if (i >= length - 1) continue;
            value.append(separator);
        }
        writer.setValue(value.toString());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String object = reader.getValue();
        if (object != null) {
            List<String> values = TextUtils.stringToList(object, separator);
            Class<?> componentType = context.getRequiredType().getComponentType();
            Object array = Array.newInstance(componentType, values.size());
            for (int i = 0; i < values.size(); ++i) {
                String v = values.get(i);
                if (componentType == Integer.class || componentType == Integer.TYPE) {
                    Array.set(array, i, Integer.valueOf(v));
                    continue;
                }
                if (componentType == Character.class || componentType == Character.TYPE) {
                    Array.set(array, i, Character.valueOf(v.charAt(0)));
                    continue;
                }
                if (componentType == Byte.class || componentType == Byte.TYPE) {
                    Array.set(array, i, Byte.valueOf(v));
                    continue;
                }
                if (componentType == Short.class || componentType == Short.TYPE) {
                    Array.set(array, i, Short.valueOf(v));
                    continue;
                }
                if (componentType == Long.class || componentType == Long.TYPE) {
                    Array.set(array, i, Long.valueOf(v));
                    continue;
                }
                if (componentType == Float.class || componentType == Float.TYPE) {
                    Array.set(array, i, Float.valueOf(v));
                    continue;
                }
                if (componentType == Double.class || componentType == Double.TYPE) {
                    Array.set(array, i, Double.valueOf(v));
                    continue;
                }
                if (componentType == Color.class) {
                    Array.set(array, i, ColorConverter.colorFromString(v));
                    continue;
                }
                if (componentType == Insets.class) {
                    Array.set(array, i, InsetsConverter.insetsFromString(v));
                    continue;
                }
                throw new IllegalArgumentException("Unable to unmarshal array of type: " + componentType);
            }
            return array;
        }
        return null;
    }
}

