/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.clone.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.clone.CloneException;
import com.alee.api.clone.GlobalCloneBehavior;
import com.alee.api.clone.RecursiveClone;
import com.alee.utils.ReflectUtils;
import com.alee.utils.collection.ImmutableSet;
import com.alee.utils.collection.WeakHashSet;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class SetCloneBehavior
implements GlobalCloneBehavior<Set> {
    @Override
    public boolean supports(@NotNull RecursiveClone clone, @NotNull Object object) {
        return object instanceof Set;
    }

    @Override
    @NotNull
    public Set clone(@NotNull RecursiveClone clone, @NotNull Set set, int depth) {
        try {
            Class<?> setClass = set.getClass();
            Set setCopy = setClass == ImmutableSet.class || setClass == HashSet.class ? new HashSet(set.size()) : (setClass == WeakHashSet.class ? new WeakHashSet(set.size()) : (setClass == TreeSet.class ? new TreeSet() : (Set)ReflectUtils.createInstance(setClass, new Object[0])));
            if (!set.isEmpty()) {
                clone.store(set, setCopy);
                for (Object element : set) {
                    Object valueCopy = clone.clone(element, depth + 1);
                    setCopy.add(valueCopy);
                }
            }
            Set result = set instanceof ImmutableSet ? new ImmutableSet(setCopy) : setCopy;
            return result;
        }
        catch (Exception e) {
            throw new CloneException("Unable to clone set: " + set, e);
        }
    }

    @Override
    public boolean isStorable() {
        return true;
    }
}

