/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;

public enum Rotation {
    none,
    clockwise,
    counterClockwise,
    upsideDown;


    public boolean isVertical() {
        return this == clockwise || this == counterClockwise;
    }

    public Rotation rightToLeft() {
        Rotation rotation;
        switch (this) {
            case clockwise: {
                rotation = counterClockwise;
                break;
            }
            case counterClockwise: {
                rotation = clockwise;
                break;
            }
            default: {
                rotation = this;
            }
        }
        return rotation;
    }

    public Rectangle transpose(Rectangle rectangle) {
        return this.isVertical() ? new Rectangle(rectangle.x, rectangle.y, rectangle.height, rectangle.width) : new Rectangle(rectangle);
    }

    public Dimension transpose(Dimension dimension) {
        return this.isVertical() ? new Dimension(dimension.height, dimension.width) : new Dimension(dimension);
    }

    public Component.BaselineResizeBehavior adjust(Component.BaselineResizeBehavior behavior) {
        Component.BaselineResizeBehavior adjusted = behavior;
        block0 : switch (this) {
            case clockwise: 
            case counterClockwise: {
                adjusted = Component.BaselineResizeBehavior.OTHER;
                break;
            }
            case upsideDown: {
                switch (behavior) {
                    case CONSTANT_ASCENT: {
                        adjusted = Component.BaselineResizeBehavior.CONSTANT_DESCENT;
                        break block0;
                    }
                    case CONSTANT_DESCENT: {
                        adjusted = Component.BaselineResizeBehavior.CONSTANT_ASCENT;
                    }
                }
            }
        }
        return adjusted;
    }
}

