/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.merge;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.Clone;
import com.alee.api.clone.CloneException;
import com.alee.api.matcher.IdentifiableMatcher;
import com.alee.api.merge.ClonePolicy;
import com.alee.api.merge.GlobalMergeBehavior;
import com.alee.api.merge.MergeException;
import com.alee.api.merge.NullResolver;
import com.alee.api.merge.Overwriting;
import com.alee.api.merge.RecursiveMerge;
import com.alee.api.merge.UnknownResolver;
import com.alee.api.merge.behavior.BasicMergeBehavior;
import com.alee.api.merge.behavior.IndexArrayMergeBehavior;
import com.alee.api.merge.behavior.ListMergeBehavior;
import com.alee.api.merge.behavior.MapMergeBehavior;
import com.alee.api.merge.behavior.MergeableMergeBehavior;
import com.alee.api.merge.behavior.ReflectionMergeBehavior;
import com.alee.api.merge.clonepolicy.PerformClonePolicy;
import com.alee.api.merge.clonepolicy.SkipClonePolicy;
import com.alee.api.merge.nullresolver.SkippingNullResolver;
import com.alee.api.merge.unknownresolver.ExceptionUnknownResolver;
import com.alee.utils.CollectionUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.reflection.ModifierType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Merge
implements Serializable {
    @Nullable
    private static Map<String, Merge> commons;
    @NotNull
    private final ClonePolicy baseClonePolicy;
    @NotNull
    private final ClonePolicy mergedClonePolicy;
    @NotNull
    private final NullResolver nullResolver;
    @NotNull
    private final UnknownResolver unknownResolver;
    @NotNull
    private final List<GlobalMergeBehavior> behaviors;

    public Merge(@NotNull NullResolver nullResolver, @NotNull UnknownResolver unknownResolver, GlobalMergeBehavior ... behaviors) {
        this((ClonePolicy)new SkipClonePolicy(), (ClonePolicy)new SkipClonePolicy(), nullResolver, unknownResolver, new ImmutableList<GlobalMergeBehavior>(behaviors));
    }

    public Merge(@NotNull ClonePolicy baseClonePolicy, @NotNull ClonePolicy mergedClonePolicy, @NotNull NullResolver nullResolver, @NotNull UnknownResolver unknownResolver, GlobalMergeBehavior ... behaviors) {
        this(baseClonePolicy, mergedClonePolicy, nullResolver, unknownResolver, new ImmutableList<GlobalMergeBehavior>(behaviors));
    }

    public Merge(@NotNull NullResolver nullResolver, @NotNull UnknownResolver unknownResolver, @NotNull List<GlobalMergeBehavior> behaviors) {
        this((ClonePolicy)new SkipClonePolicy(), (ClonePolicy)new SkipClonePolicy(), nullResolver, unknownResolver, behaviors);
    }

    public Merge(@NotNull ClonePolicy baseClonePolicy, @NotNull ClonePolicy mergedClonePolicy, @NotNull NullResolver nullResolver, @NotNull UnknownResolver unknownResolver, @NotNull List<GlobalMergeBehavior> behaviors) {
        this.baseClonePolicy = baseClonePolicy;
        this.mergedClonePolicy = mergedClonePolicy;
        this.nullResolver = nullResolver;
        this.unknownResolver = unknownResolver;
        this.behaviors = behaviors instanceof ImmutableList ? behaviors : new ImmutableList(behaviors);
    }

    @Nullable
    public <T> T merge(@Nullable Object base, @Nullable Object merged) {
        Object baseCopy = this.cloneBase(base);
        Object mergedCopy = this.cloneMerged(merged);
        InternalMerge internalMerge = new InternalMerge();
        return internalMerge.merge(Object.class, baseCopy, mergedCopy, 0);
    }

    @NotNull
    public <T> T nonNullMerge(@NotNull Object base, @NotNull Object merged) {
        T result = this.merge(base, merged);
        if (result == null) {
            throw new MergeException("Objects merge result is null:" + base + "\n <- " + merged);
        }
        return result;
    }

    @Nullable
    public <T> T merge(@Nullable Object base, @Nullable Object merged, Object ... more) {
        Object baseCopy = this.cloneBase(base);
        Object mergedCopy = this.cloneMerged(merged);
        InternalMerge internalMerge = new InternalMerge();
        Object result = internalMerge.merge(Object.class, baseCopy, mergedCopy, 0);
        for (Object another : more) {
            Object anotherCopy = this.cloneMerged(another);
            result = internalMerge.merge(Object.class, result, anotherCopy, 0);
        }
        return result;
    }

    @NotNull
    public <T> T nonNullMerge(@NotNull Object base, @NotNull Object merged, Object ... more) {
        T result = this.merge(base, merged, more);
        if (result == null) {
            throw new MergeException("Objects merge result is null:" + base + "\n <- " + merged + "\n <- " + TextUtils.arrayToString("\n <- ", more));
        }
        return result;
    }

    @Nullable
    public <T> T merge(@NotNull Collection<?> objects) {
        if (CollectionUtils.notEmpty(objects)) {
            Iterator<?> iterator = objects.iterator();
            InternalMerge internalMerge = new InternalMerge();
            Object result = this.cloneBase(iterator.next());
            while (iterator.hasNext()) {
                Object mergedCopy = this.cloneMerged(iterator.next());
                result = internalMerge.merge(Object.class, result, mergedCopy, 0);
            }
            return (T)result;
        }
        throw new MergeException("At least one object must be specified for merge operation");
    }

    @NotNull
    public <T> T nonNullMerge(@NotNull Collection<?> objects) {
        T result = this.merge(objects);
        if (result == null) {
            throw new MergeException("Objects merge result is null:" + TextUtils.collectionToString(objects, "\n <- "));
        }
        return result;
    }

    @Nullable
    private Object cloneBase(@Nullable Object base) {
        return this.baseClonePolicy.clone(base);
    }

    @Nullable
    private Object cloneMerged(@Nullable Object merged) {
        return this.mergedClonePolicy.clone(merged);
    }

    @NotNull
    public static Merge basic() {
        String identifier = "basic";
        Merge merge = Merge.commonInstance("basic");
        if (merge == null) {
            merge = new Merge((ClonePolicy)new PerformClonePolicy(Clone.deep()), (ClonePolicy)new PerformClonePolicy(Clone.deep()), (NullResolver)new SkippingNullResolver(), (UnknownResolver)new ExceptionUnknownResolver(), new BasicMergeBehavior(), new MergeableMergeBehavior(), new IndexArrayMergeBehavior(), new MapMergeBehavior(), new ListMergeBehavior(new IdentifiableMatcher()));
            Merge.getCommons().put("basic", merge);
        }
        return merge;
    }

    @NotNull
    public static Merge basicRaw() {
        String identifier = "basicRaw";
        Merge merge = Merge.commonInstance("basicRaw");
        if (merge == null) {
            merge = new Merge((NullResolver)new SkippingNullResolver(), (UnknownResolver)new ExceptionUnknownResolver(), new BasicMergeBehavior(), new MergeableMergeBehavior(), new IndexArrayMergeBehavior(), new MapMergeBehavior(), new ListMergeBehavior(new IdentifiableMatcher()));
            Merge.getCommons().put("basicRaw", merge);
        }
        return merge;
    }

    @NotNull
    public static Merge deep() {
        String identifier = "deep";
        Merge merge = Merge.commonInstance("deep");
        if (merge == null) {
            merge = new Merge((ClonePolicy)new PerformClonePolicy(Clone.deep()), (ClonePolicy)new PerformClonePolicy(Clone.deep()), (NullResolver)new SkippingNullResolver(), (UnknownResolver)new ExceptionUnknownResolver(), new BasicMergeBehavior(), new MergeableMergeBehavior(), new IndexArrayMergeBehavior(), new MapMergeBehavior(), new ListMergeBehavior(new IdentifiableMatcher()), new ReflectionMergeBehavior(ReflectionMergeBehavior.Policy.mergeable, ModifierType.STATIC));
            Merge.getCommons().put("deep", merge);
        }
        return merge;
    }

    @NotNull
    public static Merge deepRaw() {
        String identifier = "deepRaw";
        Merge merge = Merge.commonInstance("deepRaw");
        if (merge == null) {
            merge = new Merge((NullResolver)new SkippingNullResolver(), (UnknownResolver)new ExceptionUnknownResolver(), new BasicMergeBehavior(), new MergeableMergeBehavior(), new IndexArrayMergeBehavior(), new MapMergeBehavior(), new ListMergeBehavior(new IdentifiableMatcher()), new ReflectionMergeBehavior(ReflectionMergeBehavior.Policy.mergeable, ModifierType.STATIC));
            Merge.getCommons().put("deepRaw", merge);
        }
        return merge;
    }

    @Nullable
    private static Merge commonInstance(String identifier) {
        return Merge.getCommons().get(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static Map<String, Merge> getCommons() {
        if (commons != null) return commons;
        Class<Merge> clazz = Merge.class;
        synchronized (Merge.class) {
            if (commons != null) return commons;
            commons = new ConcurrentHashMap<String, Merge>(4);
            // ** MonitorExit[var0] (shouldn't be in output)
            return commons;
        }
    }

    private class InternalMerge
    implements RecursiveMerge {
        private InternalMerge() {
        }

        @Override
        @Nullable
        public <T> T merge(@NotNull Class type, @Nullable Object base, @Nullable Object merged, int depth) {
            Object result;
            if (base != null && merged != null) {
                if (!(merged instanceof Overwriting) || !((Overwriting)merged).isOverwrite()) {
                    Object mergeResult = null;
                    for (GlobalMergeBehavior behavior : Merge.this.behaviors) {
                        if (!behavior.supports(this, type, base, merged)) continue;
                        mergeResult = behavior.merge(this, type, base, merged, depth);
                        break;
                    }
                    result = mergeResult != null ? mergeResult : Merge.this.unknownResolver.resolve(this, base, merged);
                } else {
                    result = merged;
                }
            } else {
                result = Merge.this.nullResolver.resolve(this, base, merged);
            }
            return (T)result;
        }

        @Override
        @NotNull
        public <T> T mergeFields(@NotNull Class type, @NotNull Object base, @NotNull Object merged, int depth) {
            for (GlobalMergeBehavior behavior : Merge.this.behaviors) {
                if (!(behavior instanceof ReflectionMergeBehavior)) continue;
                return (T)behavior.merge(this, type, base, merged, depth);
            }
            throw new CloneException("There is no ReflectionMergeBehavior in Merge algorithm");
        }

        @Override
        @Nullable
        public Object overwrite(@Nullable Object base, @Nullable Object merged) {
            Object result = base != null && merged != null ? merged : Merge.this.nullResolver.resolve(this, base, merged);
            return result;
        }
    }
}

