/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.merge.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.merge.GlobalMergeBehavior;
import com.alee.api.merge.MergeException;
import com.alee.api.merge.RecursiveMerge;
import com.alee.utils.ReflectUtils;
import com.alee.utils.collection.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class IndexListMergeBehavior<T extends List>
implements GlobalMergeBehavior<T, T, T> {
    @Override
    public boolean supports(@NotNull RecursiveMerge merge, @NotNull Class<T> type, @NotNull Object base, @NotNull Object merged) {
        return base instanceof List && merged instanceof List;
    }

    @Override
    @NotNull
    public T merge(@NotNull RecursiveMerge merge, @NotNull Class type, @NotNull T base, @NotNull T merged, int depth) {
        try {
            int el = base.size();
            int ml = merged.size();
            int rl = Math.max(el, ml);
            Object list = el >= ml && !(base instanceof ImmutableList) ? base : (base instanceof ArrayList || base instanceof ImmutableList ? new ArrayList(rl) : (List)ReflectUtils.createInstance(base.getClass(), new Object[0]));
            for (int i = 0; i < rl; ++i) {
                Object ev;
                if (i < el && i < ml) {
                    ev = base.get(i);
                    Object mv = merged.get(i);
                    list.set(i, merge.merge(Object.class, ev, mv, depth + 1));
                    continue;
                }
                if (i < el) {
                    ev = base.get(i);
                    list.set(i, ev);
                    continue;
                }
                Object mv = merged.get(i);
                list.set(i, mv);
            }
            Object result = base instanceof ImmutableList ? new ImmutableList(list) : list;
            return result;
        }
        catch (Exception e) {
            throw new MergeException("Unable to merge lists", e);
        }
    }
}

