/*
 * Decompiled with CFR 0.152.
 */
package com.alee.graphics.image.gif;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.resource.Resource;
import com.alee.api.ui.DisabledCopySupplier;
import com.alee.api.ui.TransparentCopySupplier;
import com.alee.graphics.image.gif.FrameChangeListener;
import com.alee.graphics.image.gif.GifDecoder;
import com.alee.graphics.image.gif.GifFrame;
import com.alee.utils.CollectionUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class GifIcon
implements Icon,
DisabledCopySupplier<GifIcon>,
TransparentCopySupplier<GifIcon> {
    @NotNull
    protected final List<GifFrame> frames;
    protected final int status;
    @NotNull
    protected List<FrameChangeListener> listeners;
    protected transient int displayedFrame;
    @Nullable
    protected transient Thread gifAnimator;

    public GifIcon(@NotNull Resource resource) {
        this(resource.getInputStream());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GifIcon(@NotNull InputStream inputStream) {
        this.frames = new ArrayList<GifFrame>();
        GifDecoder gifDecoder = new GifDecoder();
        this.status = gifDecoder.read(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream));
        this.listeners = new ArrayList<FrameChangeListener>();
        if (this.status != 0) throw new RuntimeException("Unable to load GIF image, status: " + this.status);
        if (gifDecoder.getFrameCount() <= 0) throw new RuntimeException("At least one GIF frame should be provided");
        this.displayedFrame = 0;
        for (int i = 0; i < gifDecoder.getFrameCount(); ++i) {
            this.frames.add(new GifFrame(gifDecoder.getFrame(i), gifDecoder.getDelay(i)));
        }
        this.startAnimation();
    }

    public GifIcon(GifFrame ... frames) {
        this(CollectionUtils.asList(frames));
    }

    public GifIcon(@NotNull List<GifFrame> frames) {
        if (frames.size() <= 0) {
            throw new RuntimeException("At least one GIF frame should be provided");
        }
        this.frames = frames;
        this.status = 0;
        this.listeners = new ArrayList<FrameChangeListener>();
        this.displayedFrame = 0;
        this.startAnimation();
    }

    public int getStatus() {
        return this.status;
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    @NotNull
    public List<GifFrame> getFrames() {
        return CollectionUtils.copy(this.frames);
    }

    @NotNull
    public GifFrame getFrame(int index) {
        return this.frames.get(index);
    }

    public int getDisplayedFrame() {
        return this.displayedFrame;
    }

    @NotNull
    public BufferedImage getDisplayedImage() {
        return this.frames.get((int)this.displayedFrame).bufferedImage;
    }

    public void startAnimation() {
        if (this.getFrameCount() > 1 && this.gifAnimator == null) {
            this.displayedFrame = 0;
            this.gifAnimator = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            int delay;
                            Thread.sleep((delay = GifIcon.this.frames.get((int)GifIcon.this.displayedFrame).delay) == 0 ? 100L : (long)delay);
                            GifIcon.this.displayedFrame = GifIcon.this.displayedFrame == GifIcon.this.getFrameCount() - 1 ? 0 : ++GifIcon.this.displayedFrame;
                            GifIcon.this.fireFrameChanged(GifIcon.this.displayedFrame);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            });
            this.gifAnimator.setDaemon(true);
            this.gifAnimator.start();
        }
    }

    public void stopAnimation() {
        if (this.gifAnimator != null && this.gifAnimator.isAlive()) {
            this.gifAnimator.interrupt();
            try {
                this.gifAnimator.join();
                this.gifAnimator = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.getFrameCount() > 0) {
            g.drawImage(this.frames.get((int)this.displayedFrame).bufferedImage, x, y, c);
        }
    }

    @Override
    public int getIconWidth() {
        return this.frames.get((int)this.displayedFrame).bufferedImage.getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.frames.get((int)this.displayedFrame).bufferedImage.getHeight();
    }

    public void addFrameChangeListener(@NotNull FrameChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeFrameChangeListener(@NotNull FrameChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireFrameChanged(int index) {
        if (CollectionUtils.notEmpty(this.listeners)) {
            GifFrame frame = this.getFrame(index);
            for (FrameChangeListener listener : this.listeners) {
                listener.frameChanged(this, index, frame);
            }
        }
    }

    @Override
    @NotNull
    public GifIcon createDisabledCopy() {
        return new GifIcon(CollectionUtils.asList(this.frames.get(0).createDisabledCopy()));
    }

    @Override
    @NotNull
    public GifIcon createTransparentCopy(float opacity) {
        return new GifIcon(CollectionUtils.asList(this.frames.get(0).createTransparentCopy(opacity)));
    }
}

