/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.managers.language.data.Value;
import com.alee.managers.language.data.ValueCountryComparator;
import com.alee.utils.CollectionUtils;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@XStreamAlias(value="record")
public final class Record
implements Cloneable,
Serializable {
    @XStreamAsAttribute
    @NotNull
    private String key;
    @XStreamImplicit
    @NotNull
    private List<Value> values;
    @Nullable
    private transient Map<String, Value> valuesCache;

    public Record() {
        this("", new ArrayList<Value>(0));
    }

    public Record(@NotNull String key) {
        this(key, new ArrayList<Value>(0));
    }

    public Record(@NotNull String key, Value ... values) {
        this(key, CollectionUtils.asList(values));
    }

    public Record(@NotNull String key, @NotNull List<Value> values) {
        this.key = key;
        this.values = CollectionUtils.copy(values);
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    public void setKey(@NotNull String key) {
        this.key = key;
    }

    @NotNull
    public List<Value> getValues() {
        return this.values;
    }

    public void setValues(@NotNull List<Value> values) {
        this.values = values;
    }

    public void addValue(@NotNull Value value) {
        this.values.add(value);
    }

    public void removeValue(@NotNull Value value) {
        this.values.remove(value);
    }

    public void clearValues() {
        this.values.clear();
    }

    public int valuesCount() {
        return this.values.size();
    }

    protected void collectAllLocales(@NotNull List<Locale> locales) {
        for (Value value : this.values) {
            Locale locale = value.getLocale();
            if (locales.contains(locale)) continue;
            locales.add(locale);
        }
    }

    protected void collectAllCodes(@NotNull List<String> codes) {
        for (Value value : this.values) {
            String code = value.getLocale().getLanguage();
            if (codes.contains(code)) continue;
            codes.add(code);
        }
    }

    public boolean hasValue(@NotNull Locale locale) {
        return this.getValue(locale) != null;
    }

    @Nullable
    public Value getValue(@NotNull Locale locale) {
        Value value;
        String key = locale.getLanguage() + "_" + locale.getCountry();
        if (this.valuesCache != null && this.valuesCache.containsKey(key)) {
            value = this.valuesCache.get(key);
        } else {
            if (CollectionUtils.notEmpty(this.values)) {
                List<Value> values = this.getValues(locale);
                ValueCountryComparator comparator = new ValueCountryComparator(locale);
                value = CollectionUtils.max(values, comparator);
            } else {
                value = null;
            }
            if (this.valuesCache == null) {
                this.valuesCache = new HashMap<String, Value>(this.values.size());
            }
            this.valuesCache.put(key, value);
        }
        return value;
    }

    @NotNull
    public List<Value> getValues(@NotNull Locale locale) {
        ArrayList<Value> localeValues = new ArrayList<Value>(3);
        for (Value value : this.values) {
            if (!Objects.equals((Object)value.getLocale().getLanguage(), (Object)locale.getLanguage())) continue;
            localeValues.add(value);
        }
        return localeValues;
    }

    @NotNull
    public String toString() {
        return this.toString(false);
    }

    @NotNull
    public String toString(boolean boldKey) {
        return (boldKey ? "{" : "") + this.key + (boldKey ? ":b}" : "") + "[ " + TextUtils.listToString(this.values, "; ") + " ]";
    }
}

