/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.data.TranslationInformation;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Locale;

public class TranslationInformationConverter
implements Converter {
    private static final String LANGUAGE = "lang";
    private static final String TITLE = "title";
    private static final String AUTHOR = "author";

    public boolean canConvert(Class type) {
        return TranslationInformation.class.getCanonicalName().equals(type.getCanonicalName());
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TranslationInformation translation = (TranslationInformation)source;
        Locale locale = translation.getLocale();
        writer.addAttribute(LANGUAGE, LanguageUtils.toString(locale));
        writer.addAttribute(TITLE, translation.getTitle());
        writer.addAttribute(AUTHOR, translation.getAuthor());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TranslationInformation value = new TranslationInformation();
        String locale = reader.getAttribute(LANGUAGE);
        value.setLocale(LanguageUtils.fromString(locale));
        String title = reader.getAttribute(TITLE);
        value.setTitle(title);
        String author = reader.getAttribute(AUTHOR);
        value.setAuthor(author);
        return value;
    }
}

