/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.collection;

import com.alee.api.jdk.Supplier;
import java.util.Collection;

public abstract class CollectionBuilder<T, C extends Collection<T>, B extends CollectionBuilder<T, C, B>> {
    protected final C collection;

    public CollectionBuilder(C collection) {
        this.collection = collection;
    }

    public B add(T element) {
        this.collection.add(element);
        return (B)this;
    }

    public B add(boolean condition, T element) {
        if (condition) {
            this.collection.add(element);
        }
        return (B)this;
    }

    public B add(Supplier<Boolean> condition, T element) {
        if (condition.get().booleanValue()) {
            this.collection.add(element);
        }
        return (B)this;
    }

    public B addAll(Collection<? extends T> collection) {
        this.collection.addAll(collection);
        return (B)this;
    }

    public B addAll(boolean condition, Collection<? extends T> collection) {
        if (condition) {
            this.collection.addAll(collection);
        }
        return (B)this;
    }

    public B addAll(Supplier<Boolean> condition, Collection<? extends T> collection) {
        if (condition.get().booleanValue()) {
            this.collection.addAll(collection);
        }
        return (B)this;
    }

    public C build() {
        return this.collection;
    }
}

