/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.collection;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.utils.CollectionUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ImmutableSet<E>
implements Set<E>,
Cloneable,
Serializable {
    @NotNull
    protected final HashSet<E> data;

    public ImmutableSet(E ... data) {
        this.data = CollectionUtils.asHashSet(data);
    }

    public ImmutableSet(@NotNull Collection<? extends E> data) {
        this.data = new HashSet<E>(data);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object element) {
        return this.data.contains(element);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] array) {
        return this.data.toArray(array);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.data.iterator();
    }

    @Override
    public boolean add(@Nullable E element) {
        throw this.createModificationException();
    }

    @Override
    public boolean remove(@Nullable Object element) {
        throw this.createModificationException();
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        return this.data.containsAll(collection);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> collection) {
        throw this.createModificationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        throw this.createModificationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        throw this.createModificationException();
    }

    @Override
    public void clear() {
        throw this.createModificationException();
    }

    @NotNull
    protected UnsupportedOperationException createModificationException() {
        return new UnsupportedOperationException("ImmutableSet is unmodifiable");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.data.toArray());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutableSet) {
            ImmutableSet other = (ImmutableSet)o;
            return CollectionUtils.equals(this.data, other.data);
        }
        return false;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.data.toArray());
    }
}

