/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.parsing;

import com.alee.api.annotations.NotNull;
import com.alee.utils.CollectionUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.parsing.UnitsParsingException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public abstract class AbstractUnits {
    @NotNull
    protected List<Unit> units;

    public AbstractUnits(Unit ... units) {
        this(CollectionUtils.asList(units));
    }

    public AbstractUnits(@NotNull List<Unit> units) {
        this.units = units;
        Collections.sort(this.units);
    }

    public long fromString(@NotNull String text) {
        try {
            long summ = 0L;
            boolean hasNumber = false;
            boolean hasDot = false;
            boolean hasUnit = false;
            int start = 0;
            int unitStart = -1;
            String string = TextUtils.removeSpacings(TextUtils.removeLineBreaks(text.toLowerCase(Locale.ROOT)));
            for (int i = 0; i < string.length(); ++i) {
                Character next;
                char ch = string.charAt(i);
                if (Character.isDigit(ch)) {
                    hasNumber = true;
                } else if (ch == '.') {
                    if (hasDot) {
                        throw new UnitsParsingException("Two dots found in one number: " + string);
                    }
                    hasDot = true;
                } else {
                    if (!hasNumber) {
                        throw new UnitsParsingException("Units specified without specific value: " + string);
                    }
                    if (unitStart == -1) {
                        unitStart = i - start;
                    }
                    hasUnit = true;
                }
                Character c = next = i + 1 < string.length() ? Character.valueOf(string.charAt(i + 1)) : null;
                if (!hasUnit || next != null && !Character.isDigit(next.charValue()) && next.charValue() != '.') continue;
                String part = string.substring(start, i + 1);
                String value = part.substring(0, unitStart);
                String unit = part.substring(unitStart);
                for (Unit units : this.units) {
                    if (!units.uses(unit)) continue;
                    summ += units.fromString(value);
                    break;
                }
                hasNumber = false;
                hasDot = false;
                hasUnit = false;
                start = i + 1;
                unitStart = -1;
            }
            return summ;
        }
        catch (Exception e) {
            throw new UnitsParsingException("Unable to parse user-friendly unit-based text", e);
        }
    }

    @NotNull
    public String toString(long value) {
        if (value >= 0L) {
            String text;
            if (value > 0L) {
                StringBuilder result = new StringBuilder();
                for (Unit units : this.units) {
                    String amount = units.toString(value);
                    if (amount == null) continue;
                    if (result.length() > 0) {
                        result.append(" ");
                    }
                    result.append(amount);
                }
                text = result.toString();
            } else {
                Unit smallest = this.units.get(this.units.size() - 1);
                text = "0" + (String)smallest.names.get(0);
            }
            return text;
        }
        throw new UnitsParsingException("Negative values are not supported yet: " + value);
    }

    protected static final class Unit
    implements Comparable<Unit> {
        private final long amount;
        private final long limit;
        @NotNull
        private final List<String> names;

        public Unit(long amount, long limit, String ... names) {
            this.amount = amount;
            this.limit = limit;
            for (String unit : names) {
                if (TextUtils.isEmpty(unit)) {
                    throw new UnitsParsingException("Unit name cannot be empty");
                }
                for (int i = 0; i < unit.length(); ++i) {
                    char ch = unit.charAt(i);
                    if (!Character.isDigit(ch) && ch != '.') continue;
                    throw new UnitsParsingException("Digits and dot symbol are not allowed in unit: " + unit);
                }
            }
            this.names = CollectionUtils.asList(names);
        }

        public boolean uses(@NotNull String name) {
            boolean uses = false;
            for (String n : this.names) {
                if (!n.equalsIgnoreCase(name)) continue;
                uses = true;
                break;
            }
            return uses;
        }

        public long fromString(@NotNull String value) {
            return Math.round(Double.parseDouble(value) * (double)this.amount);
        }

        public String toString(long value) {
            long display = this.limit > 0L ? value / this.amount % this.limit : value / this.amount;
            return display > 0L ? display + this.names.get(0) : null;
        }

        @Override
        public int compareTo(@NotNull Unit other) {
            return this.amount < other.amount ? 1 : (this.amount > other.amount ? -1 : 0);
        }
    }
}

