/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.utils.TextUtils;
import com.alee.utils.xml.XmlException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Point;
import java.util.List;

public class PointConverter
extends AbstractSingleValueConverter {
    public boolean canConvert(Class type) {
        return Point.class.isAssignableFrom(type);
    }

    public String toString(Object obj) {
        return PointConverter.pointToString((Point)obj);
    }

    public Object fromString(String str) {
        return PointConverter.pointFromString(str);
    }

    public static String pointToString(Point point) {
        return point.x + "," + point.y;
    }

    public static Point pointFromString(String point) {
        try {
            List<String> points = TextUtils.stringToList(point, ",");
            int x = Integer.parseInt(points.get(0));
            int y = Integer.parseInt(points.get(1));
            return new Point(x, y);
        }
        catch (Exception e) {
            throw new XmlException("Unable to parse Point: " + point, e);
        }
    }
}

