/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.clone.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.clone.CloneException;
import com.alee.api.clone.GlobalCloneBehavior;
import com.alee.api.clone.RecursiveClone;
import com.alee.utils.ReflectUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class BasicCloneBehavior
implements GlobalCloneBehavior<Object> {
    @Override
    public boolean supports(@NotNull RecursiveClone clone, @NotNull Object object) {
        return this.isBasic(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Object clone(@NotNull RecursiveClone clone, @NotNull Object object, int depth) {
        if (!this.isSimpleMutable(object)) return object;
        Class<?> clazz = object.getClass();
        if (clazz == Insets.class) {
            Insets m = (Insets)object;
            return new Insets(m.top, m.left, m.bottom, m.right);
        }
        if (clazz == Dimension.class) {
            Dimension m = (Dimension)object;
            return new Dimension(m.width, m.height);
        }
        if (clazz == Point.class) {
            Point m = (Point)object;
            return new Point(m.x, m.y);
        }
        if (clazz == Point2D.Float.class) {
            Point2D.Float m = (Point2D.Float)object;
            return new Point2D.Float(m.x, m.y);
        }
        if (clazz == Point2D.Double.class) {
            Point2D.Double m = (Point2D.Double)object;
            return new Point2D.Double(m.x, m.y);
        }
        if (clazz == Line2D.Float.class) {
            Line2D.Float m = (Line2D.Float)object;
            return new Line2D.Float(m.x1, m.y1, m.x2, m.y2);
        }
        if (clazz == Line2D.Double.class) {
            Line2D.Double m = (Line2D.Double)object;
            return new Line2D.Double(m.x1, m.y1, m.x2, m.y2);
        }
        if (clazz == Rectangle.class) {
            Rectangle m = (Rectangle)object;
            return new Rectangle(m.x, m.y, m.width, m.height);
        }
        if (clazz == Rectangle2D.Float.class) {
            Rectangle2D.Float m = (Rectangle2D.Float)object;
            return new Rectangle2D.Float(m.x, m.y, m.width, m.height);
        }
        if (clazz == Rectangle2D.Double.class) {
            Rectangle2D.Double m = (Rectangle2D.Double)object;
            return new Rectangle2D.Double(m.x, m.y, m.width, m.height);
        }
        if (clazz == Ellipse2D.Float.class) {
            Ellipse2D.Float m = (Ellipse2D.Float)object;
            return new Ellipse2D.Float(m.x, m.y, m.width, m.height);
        }
        if (clazz == Ellipse2D.Double.class) {
            Ellipse2D.Double m = (Ellipse2D.Double)object;
            return new Ellipse2D.Double(m.x, m.y, m.width, m.height);
        }
        if (clazz == AtomicBoolean.class) {
            AtomicBoolean ab = (AtomicBoolean)object;
            return new AtomicBoolean(ab.get());
        }
        if (clazz == AtomicInteger.class) {
            AtomicInteger ai = (AtomicInteger)object;
            return new AtomicInteger(ai.get());
        }
        if (clazz != AtomicLong.class) throw new CloneException("Unsupported mutable type clone requested: " + clazz);
        AtomicLong al = (AtomicLong)object;
        return new AtomicLong(al.get());
    }

    @Override
    public boolean isStorable() {
        return false;
    }

    private boolean isBasic(@NotNull Object object) {
        return ReflectUtils.isPrimitive(object) || this.isSimpleImmutable(object) || this.isSimpleMutable(object);
    }

    private boolean isSimpleImmutable(@NotNull Object object) {
        Class<?> clazz = object.getClass();
        return clazz.isEnum() || clazz == Class.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz == Date.class || clazz == Color.class || clazz == Font.class || clazz == BasicStroke.class || clazz == File.class;
    }

    private boolean isSimpleMutable(@NotNull Object object) {
        Class<?> clazz = object.getClass();
        return clazz == Insets.class || Dimension2D.class.isAssignableFrom(clazz) || Point2D.class.isAssignableFrom(clazz) || Line2D.class.isAssignableFrom(clazz) || Rectangle2D.class.isAssignableFrom(clazz) || Ellipse2D.class.isAssignableFrom(clazz) || clazz == AtomicBoolean.class || clazz == AtomicInteger.class || clazz == AtomicLong.class;
    }
}

