/*
 * Decompiled with CFR 0.152.
 */
package com.alee.graphics.filters;

import com.alee.graphics.filters.TransferFilter;

public class ContrastFilter
extends TransferFilter {
    private float brightness;
    private float contrast;

    public ContrastFilter() {
        this(1.0f, 1.0f);
    }

    public ContrastFilter(float brightness, float contrast) {
        this.brightness = brightness;
        this.contrast = contrast;
    }

    @Override
    protected float transferFunction(float f) {
        f *= this.brightness;
        f = (f - 0.5f) * this.contrast + 0.5f;
        return f;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
        this.initialized = false;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setContrast(float contrast) {
        this.contrast = contrast;
        this.initialized = false;
    }

    public float getContrast() {
        return this.contrast;
    }

    public String toString() {
        return "Colors/Contrast...";
    }
}

