/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.api.Identifiable;
import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.api.merge.Mergeable;
import com.alee.api.resource.Resource;
import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.RecordCountryComparator;
import com.alee.managers.language.data.TranslationInformation;
import com.alee.managers.language.data.TranslationInformationComparator;
import com.alee.managers.language.data.Value;
import com.alee.utils.CollectionUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.collection.ImmutableSet;
import com.alee.utils.compare.Filter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@XStreamAlias(value="Dictionary")
public final class Dictionary
implements Identifiable,
Mergeable,
Cloneable,
Serializable {
    @NotNull
    private static final String ID_PREFIX = "DIC";
    @NotNull
    private final transient String id = TextUtils.generateId("DIC");
    @XStreamAsAttribute
    @Nullable
    private String name;
    @XStreamAsAttribute
    @Nullable
    private String prefix;
    @XStreamImplicit(itemFieldName="record")
    @Nullable
    private List<Record> records;
    @XStreamImplicit(itemFieldName="Dictionary")
    @Nullable
    private List<Dictionary> dictionaries;
    @XStreamAlias(value="Translations")
    @Nullable
    private List<TranslationInformation> translations;
    @Nullable
    private transient List<Locale> allLocales;
    @Nullable
    private transient List<Locale> supportedLocales;
    @Nullable
    private transient Map<String, Record> recordsCache;
    @Nullable
    private transient Map<String, Dictionary> dictionariesCache;

    public Dictionary() {
        this(null, null);
    }

    public Dictionary(@Nullable String prefix) {
        this(prefix, null);
    }

    public Dictionary(@Nullable String prefix, @Nullable String name) {
        this.prefix = prefix;
        this.name = name;
    }

    public Dictionary(@NotNull Resource resource) {
        this(resource.getInputStream());
    }

    public Dictionary(@NotNull InputStream inputStream) {
        XmlUtils.fromXML(inputStream, (Object)this);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public synchronized void setName(@Nullable String name) {
        this.name = name;
    }

    @Nullable
    public String getPrefix() {
        return this.prefix;
    }

    public synchronized void setPrefix(@Nullable String prefix) {
        this.prefix = prefix;
    }

    public synchronized int recordsCount() {
        return this.records != null ? this.records.size() : 0;
    }

    public synchronized int totalRecordsCount() {
        int count;
        int n = count = this.records != null ? this.records.size() : 0;
        if (CollectionUtils.notEmpty(this.dictionaries)) {
            for (Dictionary dictionary : this.dictionaries) {
                count += dictionary.totalRecordsCount();
            }
        }
        return count;
    }

    @NotNull
    public synchronized List<Record> getRecords() {
        return this.records != null ? new ImmutableList<Record>((Collection<Record>)this.records) : new ImmutableList<Record>(new Record[0]);
    }

    public synchronized void setRecords(@Nullable List<Record> records) {
        this.records = records;
    }

    @Nullable
    public synchronized Record getRecord(@NotNull String key, @NotNull Locale locale) {
        Record result;
        String cacheKey = key + "." + LanguageUtils.toString(locale);
        if (this.recordsCache != null && this.recordsCache.containsKey(cacheKey)) {
            result = this.recordsCache.get(cacheKey);
        } else {
            String subKey;
            String dicPrefix = this.usablePrefix();
            String string = subKey = key.startsWith(dicPrefix) ? key.substring(dicPrefix.length()) : null;
            if (subKey != null) {
                if (this.dictionariesCache != null && this.dictionariesCache.containsKey(cacheKey)) {
                    result = this.dictionariesCache.get(cacheKey).getRecord(subKey, locale);
                } else {
                    Record record = null;
                    Dictionary source = this;
                    RecordCountryComparator comparator = new RecordCountryComparator(locale);
                    if (CollectionUtils.notEmpty(this.records)) {
                        List<Record> fitting = this.collectLocalRecords(subKey, new ArrayList<Record>(3));
                        record = CollectionUtils.max(fitting, comparator);
                    }
                    if (CollectionUtils.notEmpty(this.dictionaries)) {
                        for (int i = this.dictionaries.size() - 1; i >= 0; --i) {
                            Dictionary dictionary = this.dictionaries.get(i);
                            Record subRecord = dictionary.getRecord(subKey, locale);
                            if (subRecord == null || record != null && comparator.compare(record, subRecord) <= 0) continue;
                            record = subRecord;
                            source = dictionary;
                        }
                    }
                    result = record;
                    if (source == this) {
                        if (this.recordsCache == null) {
                            this.recordsCache = new HashMap<String, Record>(this.recordsCount());
                        }
                        this.recordsCache.put(cacheKey, result);
                    } else {
                        if (this.dictionariesCache == null) {
                            this.dictionariesCache = new HashMap<String, Dictionary>(this.dictionariesCount() * 5);
                        }
                        this.dictionariesCache.put(cacheKey, source);
                    }
                }
            } else {
                result = null;
            }
        }
        return result;
    }

    @NotNull
    private synchronized List<Record> collectLocalRecords(@NotNull String key, @NotNull List<Record> results) {
        if (CollectionUtils.notEmpty(this.records)) {
            for (Record record : this.records) {
                if (!Objects.equals((Object)record.getKey(), (Object)key)) continue;
                results.add(record);
            }
        }
        return results;
    }

    public synchronized void addRecord(@NotNull Record record) {
        if (this.records == null) {
            this.records = new ArrayList<Record>(1);
        }
        this.records.add(record);
        this.destroyRecordCaches(record);
    }

    public synchronized void removeRecord(@NotNull Record record) {
        if (this.records != null) {
            this.records.remove(record);
            this.destroyRecordCaches(record);
        }
    }

    public synchronized void removeRecord(@NotNull String key) {
        if (CollectionUtils.notEmpty(this.records)) {
            Iterator<Record> iterator = this.records.iterator();
            while (iterator.hasNext()) {
                Record record = iterator.next();
                if (!record.getKey().equals(key)) continue;
                iterator.remove();
                this.destroyRecordCaches(record);
                break;
            }
        }
    }

    private void destroyRecordCaches(@NotNull Record record) {
        this.clearLocaleCaches();
        if (this.recordsCache != null || this.dictionariesCache != null) {
            ImmutableSet<String> keys = new ImmutableSet<String>(record.getKey());
            if (this.recordsCache != null) {
                this.destroyKeys(this.recordsCache.keySet().iterator(), keys);
            }
            if (this.dictionariesCache != null) {
                this.destroyKeys(this.dictionariesCache.keySet().iterator(), keys);
            }
        }
    }

    public synchronized void clearRecords() {
        if (this.records != null) {
            this.records.clear();
            this.records = null;
            this.destroyRecordCaches();
        }
    }

    private void destroyRecordCaches() {
        this.clearLocaleCaches();
        if (this.recordsCache != null) {
            this.recordsCache.clear();
            this.recordsCache = null;
        }
    }

    @NotNull
    public synchronized Set<String> getKeys() {
        return this.getKeys("");
    }

    @NotNull
    private Set<String> getKeys(@NotNull String prefix) {
        return this.collectKeys(prefix, new HashSet<String>(this.totalRecordsCount()));
    }

    @NotNull
    private Set<String> collectKeys(@NotNull String prefix, @NotNull Set<String> keys) {
        String p = prefix + this.usablePrefix();
        if (this.records != null) {
            for (Record record : this.records) {
                keys.add(p + record.getKey());
            }
        }
        if (this.dictionaries != null) {
            for (Dictionary dictionary : this.dictionaries) {
                dictionary.collectKeys(p, keys);
            }
        }
        return keys;
    }

    public synchronized int dictionariesCount() {
        return this.dictionaries != null ? this.dictionaries.size() : 0;
    }

    @NotNull
    public synchronized List<Dictionary> getDictionaries() {
        return this.dictionaries != null ? new ImmutableList<Dictionary>((Collection<Dictionary>)this.dictionaries) : new ImmutableList<Dictionary>(new Dictionary[0]);
    }

    public synchronized void setDictionaries(@Nullable List<Dictionary> dictionaries) {
        this.dictionaries = dictionaries;
    }

    public synchronized void addDictionary(@NotNull Dictionary dictionary) {
        if (this.dictionaries == null) {
            this.dictionaries = new ArrayList<Dictionary>();
        }
        this.dictionaries.add(dictionary);
        this.destroyDictionaryCaches(dictionary);
    }

    public synchronized void removeDictionary(@NotNull Dictionary dictionary) {
        if (this.dictionaries != null) {
            this.dictionaries.remove(dictionary);
            this.destroyDictionaryCaches(dictionary);
        }
    }

    private void destroyDictionaryCaches(@NotNull Dictionary dictionary) {
        this.clearLocaleCaches();
        if (this.recordsCache != null || this.dictionariesCache != null) {
            Set<String> keys = dictionary.getKeys(this.usablePrefix());
            if (this.recordsCache != null) {
                this.destroyKeys(this.recordsCache.keySet().iterator(), keys);
            }
            if (this.dictionariesCache != null) {
                this.destroyKeys(this.dictionariesCache.keySet().iterator(), keys);
            }
        }
    }

    private void clearLocaleCaches() {
        if (this.allLocales != null) {
            this.allLocales.clear();
            this.allLocales = null;
        }
        if (this.supportedLocales != null) {
            this.supportedLocales.clear();
            this.supportedLocales = null;
        }
    }

    private void destroyKeys(@NotNull Iterator<String> cachedKeys, @NotNull Set<String> keys) {
        block0: while (cachedKeys.hasNext()) {
            String cachedKey = cachedKeys.next();
            for (String key : keys) {
                if (!cachedKey.startsWith(key)) continue;
                cachedKeys.remove();
                continue block0;
            }
        }
    }

    public synchronized void clearDictionaries() {
        if (this.dictionaries != null) {
            this.dictionaries.clear();
            this.dictionaries = null;
            this.destroyDictionaryCaches();
        }
    }

    private void destroyDictionaryCaches() {
        if (this.dictionariesCache != null) {
            this.dictionariesCache.clear();
            this.dictionariesCache = null;
        }
    }

    @NotNull
    public synchronized List<TranslationInformation> getTranslations() {
        return this.translations != null ? new ImmutableList<TranslationInformation>((Collection<TranslationInformation>)this.translations) : new ImmutableList<TranslationInformation>(new TranslationInformation[0]);
    }

    public synchronized void setTranslations(@Nullable List<TranslationInformation> translations) {
        this.translations = translations;
    }

    @Nullable
    public synchronized TranslationInformation getTranslation(@NotNull Locale locale) {
        ArrayList<TranslationInformation> translations = new ArrayList<TranslationInformation>(1 + this.dictionariesCount());
        this.collectLanguages(locale, translations);
        if (CollectionUtils.isEmpty(translations)) {
            ArrayList<Locale> locales = new ArrayList<Locale>();
            this.collectLocales(locales);
            for (Locale lc : locales) {
                translations.add(new TranslationInformation(lc, lc.getDisplayLanguage(), "WebLaF"));
            }
        }
        TranslationInformation info = translations.size() > 1 ? Collections.max(translations, new TranslationInformationComparator(locale)) : (translations.size() == 1 ? (TranslationInformation)translations.get(0) : null);
        return info;
    }

    private void collectLanguages(@NotNull Locale locale, @NotNull List<TranslationInformation> translations) {
        if (CollectionUtils.notEmpty(this.translations)) {
            for (TranslationInformation language : this.translations) {
                if (!language.getLocale().getLanguage().equals(locale.getLanguage())) continue;
                translations.add(language);
            }
        }
        if (CollectionUtils.notEmpty(this.dictionaries)) {
            for (Dictionary subdictionary : this.dictionaries) {
                subdictionary.collectLanguages(locale, translations);
            }
        }
    }

    private void collectLocales(@NotNull List<Locale> locales) {
        if (CollectionUtils.notEmpty(this.records)) {
            for (Record record : this.records) {
                for (Value value : record.getValues()) {
                    locales.add(value.getLocale());
                }
                if (!CollectionUtils.notEmpty(locales)) continue;
                break;
            }
        }
        if (CollectionUtils.isEmpty(locales) && CollectionUtils.notEmpty(this.dictionaries)) {
            for (Dictionary subdictionary : this.dictionaries) {
                subdictionary.collectLocales(locales);
                if (!CollectionUtils.notEmpty(locales)) continue;
                break;
            }
        }
    }

    public synchronized void addTranslation(@NotNull TranslationInformation translation) {
        if (this.translations == null) {
            this.translations = new ArrayList<TranslationInformation>(1);
        }
        this.translations.add(translation);
    }

    @NotNull
    public synchronized List<Locale> getAllLocales() {
        if (this.allLocales == null) {
            this.allLocales = new ArrayList<Locale>();
            this.collectAllLocales(this.allLocales);
        }
        return new ImmutableList<Locale>((Collection<Locale>)this.allLocales);
    }

    private void collectAllLocales(@NotNull List<Locale> locales) {
        if (CollectionUtils.notEmpty(this.records)) {
            for (Record record : this.records) {
                record.collectAllLocales(locales);
            }
        }
        if (CollectionUtils.notEmpty(this.dictionaries)) {
            for (Dictionary dictionary : this.dictionaries) {
                dictionary.collectAllLocales(locales);
            }
        }
    }

    @NotNull
    public synchronized List<Locale> getSupportedLocales() {
        if (this.supportedLocales == null) {
            this.supportedLocales = this.collectSupportedLocales(null);
        }
        if (this.supportedLocales == null) {
            this.supportedLocales = new ArrayList<Locale>(0);
        }
        return new ImmutableList<Locale>((Collection<Locale>)this.supportedLocales);
    }

    @Nullable
    protected List<Locale> collectSupportedLocales(@Nullable List<Locale> locales) {
        if (CollectionUtils.notEmpty(this.records)) {
            if (locales == null) {
                locales = new ArrayList<Locale>();
                for (Record record : this.records) {
                    record.collectAllLocales(locales);
                }
            } else {
                locales = this.filterLocales(locales);
            }
        }
        if (CollectionUtils.notEmpty(this.dictionaries)) {
            for (Dictionary dictionary : this.dictionaries) {
                locales = dictionary.collectSupportedLocales(locales);
            }
        }
        return locales;
    }

    @NotNull
    private List<Locale> filterLocales(@NotNull List<Locale> locales) {
        List<Locale> filtered;
        if (CollectionUtils.notEmpty(this.records)) {
            final ArrayList<String> languageCodes = new ArrayList<String>();
            for (Record record : this.records) {
                record.collectAllCodes(languageCodes);
            }
            filtered = languageCodes.size() > 0 ? CollectionUtils.filter(locales, new Filter<Locale>(){

                @Override
                public boolean accept(Locale locale) {
                    return languageCodes.contains(locale.getLanguage());
                }
            }) : locales;
        } else {
            filtered = locales;
        }
        return filtered;
    }

    @NotNull
    private String usablePrefix() {
        return TextUtils.notEmpty(this.prefix) ? this.prefix + "." : "";
    }

    public boolean equals(@Nullable Object obj) {
        return obj != null && obj instanceof Dictionary && ((Dictionary)obj).getId().equals(this.getId());
    }

    @NotNull
    public String toString() {
        return (this.name != null ? this.name + " " : "") + (this.getPrefix() != null ? " [" + this.getPrefix() + "]" : "") + (this.recordsCount() > 0 ? " [R:" + this.recordsCount() + "]" : "") + (this.dictionariesCount() > 0 ? " [D:" + this.dictionariesCount() + "]" : "");
    }
}

