/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.task;

import com.alee.api.annotations.NotNull;
import com.alee.managers.task.TaskException;
import com.alee.managers.task.TaskGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class TaskManager {
    public static final String FILE_SYSTEM = "FileSystem";
    public static final String REMOTE_REQUEST = "RemoteRequest";
    public static final String COMPUTATION = "Computation";
    private static Map<String, TaskGroup> groups;
    private static boolean initialized;

    public static void initialize() {
        if (!initialized) {
            groups = new HashMap<String, TaskGroup>();
            TaskManager.registerGroup(new TaskGroup(FILE_SYSTEM, 4));
            TaskManager.registerGroup(new TaskGroup(REMOTE_REQUEST, 4));
            TaskManager.registerGroup(new TaskGroup(COMPUTATION, 8));
            initialized = true;
        }
    }

    public static boolean exists(@NotNull TaskGroup group) {
        return TaskManager.exists(group.getId());
    }

    public static boolean exists(@NotNull String groupId) {
        return groups.containsKey(groupId);
    }

    @NotNull
    public static TaskGroup getGroup(@NotNull String groupId) {
        if (TaskManager.exists(groupId)) {
            return groups.get(groupId);
        }
        throw new TaskException("ThreadGroup(" + groupId + ") doesn't exist");
    }

    public static void registerGroup(@NotNull TaskGroup group) {
        if (TaskManager.exists(group)) {
            throw new TaskException("Use ConcurrencyManager.configure(...) to reconfigure ThreadGroup(" + group.getId() + ")");
        }
        groups.put(group.getId(), group);
    }

    public static void configureGroup(@NotNull TaskGroup group) {
        if (!TaskManager.exists(group)) {
            throw new TaskException("ThreadGroup(" + group.getId() + ") doesn't exist");
        }
        groups.put(group.getId(), group);
    }

    @NotNull
    public static Future<?> execute(@NotNull String groupId, @NotNull Runnable runnable) {
        return TaskManager.getGroup(groupId).execute(runnable);
    }

    @NotNull
    public static <V> Future<V> execute(@NotNull String groupId, @NotNull Callable<V> callable) {
        return TaskManager.getGroup(groupId).execute(callable);
    }

    public static void shutdown(@NotNull String groupId) {
        TaskManager.getGroup(groupId).shutdown();
    }

    public static void shutdownNow(@NotNull String groupId) {
        TaskManager.getGroup(groupId).shutdownNow();
    }
}

