/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.UtilityException;
import java.lang.reflect.Array;

public final class ArrayUtils {
    private ArrayUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static <T> boolean isEmpty(T ... data) {
        return data == null || data.length == 0;
    }

    public static <T> boolean notEmpty(T ... data) {
        return data != null && data.length > 0;
    }

    public static boolean contains(int number, @NotNull int[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(long number, @NotNull long[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(float number, @NotNull float[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(double number, @NotNull double[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(char character, @NotNull char[] array) {
        return ArrayUtils.indexOf(character, array) != -1;
    }

    public static boolean contains(byte data, @NotNull byte[] array) {
        return ArrayUtils.indexOf(data, array) != -1;
    }

    public static boolean contains(@Nullable String text, @NotNull String[] array) {
        return ArrayUtils.indexOf(text, array) != -1;
    }

    public static boolean contains(@Nullable Object object, @NotNull Object[] array) {
        return ArrayUtils.indexOf(object, array) != -1;
    }

    public static int indexOf(int number, @NotNull int[] array) {
        int index = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int indexOf(long number, @NotNull long[] array) {
        int index = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int indexOf(float number, @NotNull float[] array) {
        int index = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int indexOf(double number, @NotNull double[] array) {
        int index = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int indexOf(char character, @NotNull char[] array) {
        int index = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != character) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int indexOf(byte data, @NotNull byte[] array) {
        int index = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != data) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int indexOf(@Nullable String text, @NotNull String[] array) {
        return ArrayUtils.indexOf(text, array, false);
    }

    public static int indexOf(@Nullable String text, @NotNull String[] array, boolean ignoreCase) {
        int index = -1;
        for (int i = 0; i < array.length; ++i) {
            String txt = array[i];
            if ((txt != null || text != null) && (txt == null || text == null || !(ignoreCase ? txt.equalsIgnoreCase(text) : txt.equals(text)))) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int indexOf(@Nullable Object object, @NotNull Object[] array) {
        int index = -1;
        for (int i = 0; i < array.length; ++i) {
            Object obj = array[i];
            if ((obj != null || object != null) && (obj == null || !obj.equals(object))) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int lastIndexOf(@Nullable Object object, @NotNull Object[] array) {
        int index = -1;
        for (int i = array.length - 1; i >= 0; --i) {
            Object obj = array[i];
            if ((obj != null || object != null) && (obj == null || !obj.equals(object))) continue;
            index = i;
            break;
        }
        return index;
    }

    @NotNull
    public static <T> T[] remove(@NotNull T[] array, @Nullable T object) {
        T[] newArray = ArrayUtils.createArray(array, array.length - 1);
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (mod == 0 && array[i] == object) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static int[] remove(@NotNull int[] array, int index) {
        int[] newArray = new int[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static float[] remove(@NotNull float[] array, int index) {
        float[] newArray = new float[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static double[] remove(@NotNull double[] array, int index) {
        double[] newArray = new double[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static char[] remove(@NotNull char[] array, int index) {
        char[] newArray = new char[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static byte[] remove(@NotNull byte[] array, int index) {
        byte[] newArray = new byte[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static boolean[] remove(@NotNull boolean[] array, int index) {
        boolean[] newArray = new boolean[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static <T> T[] remove(@NotNull T[] array, int index) {
        T[] newArray = ArrayUtils.createArray(array, array.length - 1);
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static int[] insert(@NotNull int[] array, int index, int object) {
        int[] newArray = new int[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static float[] insert(@NotNull float[] array, int index, float object) {
        float[] newArray = new float[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static double[] insert(@NotNull double[] array, int index, double object) {
        double[] newArray = new double[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static char[] insert(@NotNull char[] array, int index, char object) {
        char[] newArray = new char[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static byte[] insert(@NotNull byte[] array, int index, byte object) {
        byte[] newArray = new byte[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static boolean[] insert(@NotNull boolean[] array, int index, boolean object) {
        boolean[] newArray = new boolean[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static <T> T[] insert(@NotNull T[] array, int index, @Nullable T object) {
        T[] newArray = ArrayUtils.createArray(array, array.length + 1);
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    @NotNull
    public static <T> T[] createArray(@NotNull T[] array, int length) {
        return ArrayUtils.createArray(array.getClass().getComponentType(), length);
    }

    @NotNull
    public static <T> T[] createArray(@NotNull Class<T> classType, int length) {
        return (Object[])Array.newInstance(classType, length);
    }

    public static boolean equals(@Nullable int[] array1, @Nullable int[] array2) {
        boolean equals;
        if (array1 == null && array2 == null) {
            equals = true;
        } else if (array1 == null || array2 == null || array1.length != array2.length) {
            equals = false;
        } else {
            boolean eq = true;
            for (int number : array1) {
                if (ArrayUtils.contains(number, array2)) continue;
                eq = false;
                break;
            }
            equals = eq;
        }
        return equals;
    }

    public static boolean equals(@Nullable long[] array1, @Nullable long[] array2) {
        boolean equals;
        if (array1 == null && array2 == null) {
            equals = true;
        } else if (array1 == null || array2 == null || array1.length != array2.length) {
            equals = false;
        } else {
            boolean eq = true;
            for (long number : array1) {
                if (ArrayUtils.contains(number, array2)) continue;
                eq = false;
                break;
            }
            equals = eq;
        }
        return equals;
    }

    public static boolean equals(@Nullable float[] array1, @Nullable float[] array2) {
        boolean equals;
        if (array1 == null && array2 == null) {
            equals = true;
        } else if (array1 == null || array2 == null || array1.length != array2.length) {
            equals = false;
        } else {
            boolean eq = true;
            for (float number : array1) {
                if (ArrayUtils.contains(number, array2)) continue;
                eq = false;
                break;
            }
            equals = eq;
        }
        return equals;
    }

    public static boolean equals(@Nullable double[] array1, @Nullable double[] array2) {
        boolean equals;
        if (array1 == null && array2 == null) {
            equals = true;
        } else if (array1 == null || array2 == null || array1.length != array2.length) {
            equals = false;
        } else {
            boolean eq = true;
            for (double number : array1) {
                if (ArrayUtils.contains(number, array2)) continue;
                eq = false;
                break;
            }
            equals = eq;
        }
        return equals;
    }

    public static boolean equals(@Nullable char[] array1, @Nullable char[] array2) {
        boolean equals;
        if (array1 == null && array2 == null) {
            equals = true;
        } else if (array1 == null || array2 == null || array1.length != array2.length) {
            equals = false;
        } else {
            boolean eq = true;
            for (char character : array1) {
                if (ArrayUtils.contains(character, array2)) continue;
                eq = false;
                break;
            }
            equals = eq;
        }
        return equals;
    }

    public static boolean equals(@Nullable byte[] array1, @Nullable byte[] array2) {
        boolean equals;
        if (array1 == null && array2 == null) {
            equals = true;
        } else if (array1 == null || array2 == null || array1.length != array2.length) {
            equals = false;
        } else {
            boolean eq = true;
            for (byte data : array1) {
                if (ArrayUtils.contains(data, array2)) continue;
                eq = false;
                break;
            }
            equals = eq;
        }
        return equals;
    }

    public static boolean equals(@Nullable String[] array1, @Nullable String[] array2) {
        boolean equals;
        if (array1 == null && array2 == null) {
            equals = true;
        } else if (array1 == null || array2 == null || array1.length != array2.length) {
            equals = false;
        } else {
            boolean eq = true;
            for (String text : array1) {
                if (ArrayUtils.contains(text, array2)) continue;
                eq = false;
                break;
            }
            equals = eq;
        }
        return equals;
    }

    public static <T> boolean equals(@Nullable T[] array1, @Nullable T[] array2) {
        boolean equals;
        if (array1 == null && array2 == null) {
            equals = true;
        } else if (array1 == null || array2 == null || array1.length != array2.length) {
            equals = false;
        } else {
            boolean eq = true;
            for (T object : array1) {
                if (ArrayUtils.contains(object, array2)) continue;
                eq = false;
                break;
            }
            equals = eq;
        }
        return equals;
    }

    @Nullable
    public static <T> T roundRobin(int index, T ... items) {
        return items.length > 0 ? (T)items[index % items.length] : null;
    }
}

