/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.utils.TextUtils;
import com.alee.utils.UtilityException;
import java.awt.Color;
import java.util.Locale;
import java.util.Random;
import java.util.StringTokenizer;

public final class ColorUtils {
    private static final Color TRANSPARENT_COLOR = new Color(255, 255, 255, 0);

    private ColorUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @NotNull
    public static Color transparent() {
        return TRANSPARENT_COLOR;
    }

    @NotNull
    public static Color grayscale(@NotNull Color color) {
        int avg = (int)((double)color.getRed() * 0.299 + (double)color.getGreen() * 0.587 + (double)color.getBlue() * 0.114);
        return new Color(avg, avg, avg, color.getAlpha());
    }

    @NotNull
    public static Color transparent(@NotNull Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    @NotNull
    public static Color opaque(@NotNull Color color) {
        return color.getAlpha() != 255 ? ColorUtils.transparent(color, 255) : color;
    }

    @NotNull
    public static Color webSafe(@NotNull Color color) {
        return new Color(ColorUtils.webSafe(color.getRed()), ColorUtils.webSafe(color.getGreen()), ColorUtils.webSafe(color.getBlue()), ColorUtils.webSafe(color.getAlpha()));
    }

    public static int webSafe(int value) {
        int webSafe = 0 <= value && value <= 51 ? (value > 51 - value ? 51 : 0) : (51 < value && value <= 102 ? (value - 51 > 102 - value ? 102 : 51) : (102 < value && value <= 153 ? (value - 102 > 153 - value ? 153 : 102) : (153 < value && value <= 204 ? (value - 153 > 204 - value ? 204 : 153) : (204 < value && value <= 255 ? (value - 204 > 255 - value ? 255 : 204) : value))));
        return webSafe;
    }

    @NotNull
    public static Color intermediate(@NotNull Color color1, @NotNull Color color2, float progress) {
        Color intermediate = progress <= 0.0f ? color1 : (progress >= 1.0f ? color2 : new Color(ColorUtils.intermediate(color1.getRed(), color2.getRed(), progress), ColorUtils.intermediate(color1.getGreen(), color2.getGreen(), progress), ColorUtils.intermediate(color1.getBlue(), color2.getBlue(), progress), ColorUtils.intermediate(color1.getAlpha(), color2.getAlpha(), progress)));
        return intermediate;
    }

    private static int intermediate(int value1, int value2, float progress) {
        return value1 + Math.round(((float)value2 - (float)value1) * progress);
    }

    @NotNull
    public static String toHex(@NotNull Color color) {
        StringBuilder hex = new StringBuilder("#");
        hex.append(ColorUtils.toHexValue(color.getRed()));
        hex.append(ColorUtils.toHexValue(color.getGreen()));
        hex.append(ColorUtils.toHexValue(color.getBlue()));
        if (color.getAlpha() < 255) {
            hex.append(ColorUtils.toHexValue(color.getAlpha()));
        }
        return hex.toString().toUpperCase(Locale.ROOT);
    }

    @NotNull
    private static String toHexValue(int value) {
        String hex = Integer.toHexString(value);
        return hex.length() == 1 ? "0" + hex : hex;
    }

    @NotNull
    public static Color fromHex(@NotNull String hex) {
        int offset = hex.startsWith("#") ? 1 : 0;
        int red = ColorUtils.fromHexValue(hex.substring(offset, offset + 2));
        int green = ColorUtils.fromHexValue(hex.substring(offset + 2, offset + 4));
        int blue = ColorUtils.fromHexValue(hex.substring(offset + 4, offset + 6));
        int alpha = hex.length() > 7 ? ColorUtils.fromHexValue(hex.substring(offset + 6, offset + 8)) : 255;
        return new Color(red, green, blue, alpha);
    }

    private static int fromHexValue(@NotNull String hex) {
        return Integer.valueOf(hex, 16);
    }

    @NotNull
    public static String toRGBA(@NotNull Color color) {
        return ColorUtils.toRGBA(color, ",");
    }

    @NotNull
    public static String toRGBA(@NotNull Color color, @NotNull String separator) {
        return color.getRed() + separator + color.getGreen() + separator + color.getBlue() + (color.getAlpha() < 255 ? separator + color.getAlpha() : "");
    }

    @NotNull
    public static Color fromRGBA(@NotNull String rgba) {
        return ColorUtils.fromRGBA(rgba, ",");
    }

    @NotNull
    public static Color fromRGBA(@NotNull String rgba, @NotNull String separator) {
        Color color;
        String clean = TextUtils.removeSpacings(rgba);
        StringTokenizer st = new StringTokenizer(clean, separator, false);
        int count = st.countTokens();
        if (count == 3) {
            color = new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        } else if (count == 4) {
            color = new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        } else {
            throw new RuntimeException("Unable to parse RGB color: " + rgba);
        }
        return color;
    }

    @NotNull
    public static Color softColor(@NotNull Color base) {
        Random random = new Random();
        return new Color((random.nextInt(256) + base.getRed()) / 2, (random.nextInt(256) + base.getGreen()) / 2, (random.nextInt(256) + base.getBlue()) / 2);
    }
}

