/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.UtilityException;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.slf4j.LoggerFactory;

public final class CoreSwingUtils {
    private CoreSwingUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static void enableEventQueueLogging() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new EventQueue(){

            @Override
            protected void dispatchEvent(AWTEvent event) {
                try {
                    super.dispatchEvent(event);
                }
                catch (Throwable e) {
                    String msg = "Uncaught EventQueue exception: %s";
                    LoggerFactory.getLogger(CoreSwingUtils.class).error(String.format("Uncaught EventQueue exception: %s", e.toString()), e);
                }
            }
        });
    }

    @Nullable
    public static AWTEvent getCurrentEvent() {
        return EventQueue.getCurrentEvent();
    }

    public static int getCurrentEventModifiers() {
        int modifiers = 0;
        AWTEvent currentEvent = CoreSwingUtils.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        return modifiers;
    }

    @NotNull
    public static Window getNonNullWindowAncestor(@NotNull Component component) {
        Window window = CoreSwingUtils.getWindowAncestor(component);
        if (window == null) {
            throw new UtilityException("Unable to retrieve Window ancestor for Component: " + component);
        }
        return window;
    }

    @Nullable
    public static Window getWindowAncestor(@Nullable Component component) {
        Window window;
        if (component != null) {
            if (!(component instanceof Window)) {
                Container parent;
                for (parent = component.getParent(); parent != null && !(parent instanceof Window); parent = parent.getParent()) {
                }
                window = (Window)parent;
            } else {
                window = (Window)component;
            }
        } else {
            window = null;
        }
        return window;
    }

    @NotNull
    public static JRootPane getNonNullRootPane(@NotNull Component component) {
        JRootPane rootPane = CoreSwingUtils.getRootPane(component);
        if (rootPane == null) {
            throw new UtilityException("Unable to retrieve JRootPane for Component: " + component);
        }
        return rootPane;
    }

    @Nullable
    public static JRootPane getRootPane(@Nullable Component component) {
        JRootPane rootPane = null;
        if (component instanceof JRootPane) {
            rootPane = (JRootPane)component;
        } else if (component instanceof RootPaneContainer) {
            rootPane = ((RootPaneContainer)((Object)component)).getRootPane();
        } else if (component != null) {
            for (Component other = component; other != null; other = other.getParent()) {
                if (!(other instanceof JRootPane)) continue;
                rootPane = (JRootPane)other;
                break;
            }
        }
        return rootPane;
    }

    public static boolean isVisibleOnScreen(@NotNull Component component) {
        boolean visible;
        if (component.isShowing()) {
            Rectangle bounds = CoreSwingUtils.getBoundsOnScreen(component, true);
            visible = bounds.width > 0 && bounds.height > 0;
        } else {
            visible = false;
        }
        return visible;
    }

    @NotNull
    public static Rectangle getBoundsOnScreen(@NotNull Component component, boolean visibleOnly) {
        Rectangle bounds;
        Point los = CoreSwingUtils.locationOnScreen(component);
        Dimension size = component.getSize();
        if (visibleOnly) {
            Rectangle visible = CoreSwingUtils.getVisibleRect(component);
            bounds = new Rectangle(los.x + visible.x, los.y + visible.y, visible.width, visible.height);
        } else {
            bounds = new Rectangle(los, size);
        }
        return bounds;
    }

    @Nullable
    public static Rectangle getBoundsInWindow(@NotNull Component component) {
        JRootPane rootPane = CoreSwingUtils.getRootPane(component);
        Rectangle boundsInWindow = rootPane != null ? (component instanceof Window || component instanceof JApplet ? rootPane.getBounds() : CoreSwingUtils.getRelativeBounds(component, rootPane)) : null;
        return boundsInWindow;
    }

    @NotNull
    public static Rectangle getRelativeBounds(@NotNull Component component, @NotNull Component relativeTo) {
        return new Rectangle(CoreSwingUtils.getRelativeLocation(component, relativeTo), component.getSize());
    }

    @NotNull
    public static Point getRelativeLocation(@NotNull Component component, @NotNull Component relativeTo) {
        Point los = CoreSwingUtils.locationOnScreen(component);
        Point rt = CoreSwingUtils.locationOnScreen(relativeTo);
        return new Point(los.x - rt.x, los.y - rt.y);
    }

    public static boolean isAncestorOf(@Nullable Component ancestor, @Nullable Component component) {
        return ancestor instanceof Container && ((Container)ancestor).isAncestorOf(component);
    }

    public static boolean isSameAncestor(@Nullable Component component1, @Nullable Component component2) {
        return CoreSwingUtils.getWindowAncestor(component1) == CoreSwingUtils.getWindowAncestor(component2);
    }

    @NotNull
    public static Insets getWindowDecorationInsets(@Nullable Window window) {
        JRootPane rootPane;
        Insets insets = new Insets(0, 0, 0, 0);
        if ((window instanceof Dialog || window instanceof Frame) && (rootPane = CoreSwingUtils.getRootPane(window)) != null) {
            if (window.isShowing()) {
                if (window instanceof Dialog && !((Dialog)window).isUndecorated() || window instanceof Frame && !((Frame)window).isUndecorated()) {
                    Rectangle wlos = CoreSwingUtils.getBoundsOnScreen(window, false);
                    Rectangle rlos = CoreSwingUtils.getBoundsOnScreen(rootPane, false);
                    insets.top = rlos.y - wlos.y;
                    insets.left = rlos.x - wlos.x;
                    insets.bottom = wlos.y + wlos.height - rlos.y - rlos.height;
                    insets.right = wlos.x + wlos.width - rlos.x - rlos.width;
                } else {
                    insets.top = 25;
                }
            } else {
                insets.top = 25;
            }
        }
        return insets;
    }

    public static boolean isFullScreen(@Nullable Component component) {
        GraphicsDevice device;
        GraphicsConfiguration gc;
        Window window = CoreSwingUtils.getWindowAncestor(component);
        boolean fullScreen = window != null ? ((gc = window.getGraphicsConfiguration()) != null ? (device = gc.getDevice()) != null && device.getFullScreenWindow() == window : false) : false;
        return fullScreen;
    }

    @NotNull
    public static PointerInfo getPointerInfo() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            try {
                pointerInfo = (PointerInfo)ReflectUtils.createInstance(PointerInfo.class, SystemUtils.getDefaultScreenDevice(), new Point(0, 0));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create empty PointerInfo", e);
            }
        }
        return pointerInfo;
    }

    @NotNull
    public static Point getMouseLocation() {
        return CoreSwingUtils.getPointerInfo().getLocation();
    }

    @NotNull
    public static Point getMouseLocation(@NotNull Component component) {
        Point mouse = CoreSwingUtils.getMouseLocation();
        Point los = CoreSwingUtils.locationOnScreen(component);
        return new Point(mouse.x - los.x, mouse.y - los.y);
    }

    public static boolean isHovered(@NotNull Component component) {
        boolean hover = false;
        if (component.isShowing() && !CoreSwingUtils.getVisibleRect(component).isEmpty() && CoreSwingUtils.getBoundsOnScreen(component, true).contains(CoreSwingUtils.getMouseLocation())) {
            hover = true;
        }
        return hover;
    }

    @Nullable
    public static Component getTopComponentAt(@Nullable Component component, @NotNull Point point) {
        return CoreSwingUtils.getTopComponentAt(component, point.x, point.y);
    }

    @Nullable
    public static Component getTopComponentAt(@Nullable Component component, int x, int y) {
        Component top;
        if (component != null && component.isVisible() && component.contains(x, y)) {
            if (component instanceof Container) {
                Component child;
                Component topInChild = null;
                Container container = (Container)component;
                for (int i = 0; i < container.getComponentCount() && (topInChild = CoreSwingUtils.getTopComponentAt(child = container.getComponent(i), x - child.getX(), y - child.getY())) == null; ++i) {
                }
                top = topInChild != null ? topInChild : component;
            } else {
                top = component;
            }
        } else {
            top = null;
        }
        return top;
    }

    @NotNull
    public static Point locationOnScreen(@NotNull Component component) {
        try {
            return component.getLocationOnScreen();
        }
        catch (IllegalComponentStateException e) {
            throw new UtilityException("Component must be showing on the screen to determine its location: " + component);
        }
    }

    @NotNull
    public static List<JPopupMenu> getPopupMenus() {
        MenuElement[] selected = MenuSelectionManager.defaultManager().getSelectedPath();
        ArrayList<JPopupMenu> menus = new ArrayList<JPopupMenu>(selected.length);
        for (MenuElement element : selected) {
            if (!(element instanceof JPopupMenu)) continue;
            menus.add((JPopupMenu)element);
        }
        return menus;
    }

    public static boolean isMenuShortcutKeyDown(@NotNull InputEvent event) {
        return (event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    public static boolean isEventDispatchThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public static void invokeLater(@NotNull Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public static void invokeOnEventDispatchThread(@NotNull Runnable runnable) {
        if (CoreSwingUtils.isEventDispatchThread()) {
            runnable.run();
        } else {
            CoreSwingUtils.invokeLater(runnable);
        }
    }

    public static void invokeAndWait(@NotNull Runnable runnable) {
        CoreSwingUtils.invokeAndWait(runnable, false);
    }

    public static void invokeAndWait(@NotNull Runnable runnable, boolean ignoreInterrupts) {
        block5: {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeAndWait(runnable);
                }
            }
            catch (InvocationTargetException e) {
                throw new UtilityException(e);
            }
            catch (InterruptedException e) {
                if (ignoreInterrupts) break block5;
                throw new UtilityException(e);
            }
        }
    }

    @NotNull
    public static Rectangle getVisibleRect(@NotNull Component component) {
        return component instanceof JComponent ? ((JComponent)component).getVisibleRect() : CoreSwingUtils.computeVisibleRect(component, new Rectangle());
    }

    @NotNull
    private static Rectangle computeVisibleRect(@NotNull Component component, @NotNull Rectangle visibleRect) {
        Container p = component.getParent();
        Rectangle bounds = component.getBounds();
        if (p == null || p instanceof Window || p instanceof Applet) {
            visibleRect.setBounds(0, 0, bounds.width, bounds.height);
        } else {
            CoreSwingUtils.computeVisibleRect(p, visibleRect);
            visibleRect.x -= bounds.x;
            visibleRect.y -= bounds.y;
            SwingUtilities.computeIntersection(0, 0, bounds.width, bounds.height, visibleRect);
        }
        return visibleRect;
    }
}

