/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.resource.ClassResource;
import com.alee.api.resource.FileResource;
import com.alee.api.resource.Resource;
import com.alee.api.resource.UrlResource;
import com.alee.utils.NetUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.general.Pair;
import com.alee.utils.swing.Scale;
import com.alee.utils.xml.AliasProvider;
import com.alee.utils.xml.ColorConverter;
import com.alee.utils.xml.DimensionConverter;
import com.alee.utils.xml.InsetsConverter;
import com.alee.utils.xml.Point2DConverter;
import com.alee.utils.xml.StrokeConverter;
import com.alee.utils.xml.XStreamContext;
import com.alee.utils.xml.XmlDriver;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.util.CompositeClassLoader;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.slf4j.LoggerFactory;

public final class XmlUtils {
    public static final String NEAR_CLASS_ATTRIBUTE = "nearClass";
    public static final String BASE_ATTRIBUTE = "base";
    public static final String PATH_ATTRIBUTE = "path";
    public static final String URL_ATTRIBUTE = "url";
    public static final String CONTEXT_NEAR_CLASS = "Resource.nearClass";
    public static final String CONTEXT_BASE = "Resource.base";
    private static boolean aliasJdkClasses = true;
    private static HierarchicalStreamDriver hierarchicalStreamDriver;
    @Nullable
    private static XStream xStream;

    private XmlUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @NotNull
    public static XStream getXStream() {
        if (xStream == null) {
            XmlUtils.initializeXStream();
        }
        return xStream;
    }

    private static void initializeXStream() {
        try {
            PureJavaReflectionProvider reflectionProvider = new PureJavaReflectionProvider();
            hierarchicalStreamDriver = new XmlDriver();
            xStream = new XStream((ReflectionProvider)reflectionProvider, hierarchicalStreamDriver);
            xStream.addPermission(AnyTypePermission.ANY);
            if (XmlUtils.class.getClassLoader() != xStream.getClass().getClassLoader()) {
                ClassLoader classLoader = xStream.getClassLoader();
                if (classLoader instanceof CompositeClassLoader) {
                    ((CompositeClassLoader)classLoader).add(XmlUtils.class.getClassLoader());
                } else {
                    CompositeClassLoader compositeClassLoader = new CompositeClassLoader();
                    compositeClassLoader.add(XmlUtils.class.getClassLoader());
                    xStream.setClassLoader((ClassLoader)compositeClassLoader);
                }
            }
            if (aliasJdkClasses) {
                xStream.alias("Point", Point.class);
                xStream.useAttributeFor(Point.class, "x");
                xStream.useAttributeFor(Point.class, "y");
                xStream.alias("Point2D", Point2D.class);
                xStream.registerConverter((SingleValueConverter)new Point2DConverter());
                xStream.alias("Dimension", Dimension.class);
                xStream.registerConverter((SingleValueConverter)new DimensionConverter());
                xStream.alias("Rectangle", Rectangle.class);
                xStream.useAttributeFor(Rectangle.class, "x");
                xStream.useAttributeFor(Rectangle.class, "y");
                xStream.useAttributeFor(Rectangle.class, "width");
                xStream.useAttributeFor(Rectangle.class, "height");
                xStream.alias("Font", Font.class);
                xStream.alias("Color", Color.class);
                xStream.registerConverter((SingleValueConverter)new ColorConverter());
                xStream.alias("Insets", Insets.class);
                xStream.registerConverter((SingleValueConverter)new InsetsConverter());
                xStream.alias("Stroke", Stroke.class);
                xStream.registerConverter((SingleValueConverter)new StrokeConverter());
            }
            xStream.processAnnotations(Pair.class);
            xStream.processAnnotations(Scale.class);
        }
        catch (Exception e) {
            throw new UtilityException("Unable to initialize XStream instance", e);
        }
    }

    public static boolean isAliasJdkClasses() {
        return aliasJdkClasses;
    }

    public static void setAliasJdkClasses(boolean alias) {
        aliasJdkClasses = alias;
    }

    public static void processAnnotations(@NotNull Class type) {
        XmlUtils.getXStream().processAnnotations(type);
    }

    public static void processAnnotations(@NotNull Class[] types) {
        XmlUtils.getXStream().processAnnotations(types);
    }

    public static void alias(@NotNull String name, @NotNull Class type) {
        XmlUtils.getXStream().alias(name, type);
    }

    public static void omitField(@NotNull Class type, @NotNull String field) {
        XmlUtils.getXStream().omitField(type, field);
    }

    public static void useAttributeFor(@NotNull Class type, @NotNull String field) {
        XmlUtils.getXStream().useAttributeFor(type, field);
    }

    public static void addImplicitArray(@NotNull Class type, @NotNull String field) {
        XmlUtils.getXStream().addImplicitArray(type, field);
    }

    public static void addImplicitArray(@NotNull Class type, @NotNull String field, @NotNull String itemName) {
        XmlUtils.getXStream().addImplicitArray(type, field, itemName);
    }

    public static void registerConverter(@NotNull Converter converter) {
        XmlUtils.getXStream().registerConverter(converter);
    }

    public static void registerConverter(@NotNull SingleValueConverter converter) {
        XmlUtils.getXStream().registerConverter(converter);
    }

    public static <T extends AliasProvider> void alias(@NotNull Class<T> aliasProvider) {
        ReflectUtils.callStaticMethodSafely(aliasProvider, "provideAliases", XmlUtils.getXStream());
    }

    public static <T> T fromXML(@NotNull String xml) {
        return (T)XmlUtils.getXStream().fromXML(xml);
    }

    public static <T> T fromXML(@NotNull String xml, @NotNull Object root) {
        return (T)XmlUtils.getXStream().fromXML(xml, root);
    }

    public static <T> T fromXML(@NotNull String xml, @Nullable XStreamContext context) {
        return (T)XmlUtils.getXStream().unmarshal(hierarchicalStreamDriver.createReader((Reader)new StringReader(xml)), null, (DataHolder)context);
    }

    public static <T> T fromXML(@NotNull Resource resource) {
        return XmlUtils.fromXML(resource.getInputStream());
    }

    public static <T> T fromXML(@NotNull Resource resource, @NotNull Object root) {
        return XmlUtils.fromXML(resource.getInputStream(), root);
    }

    public static <T> T fromXML(@NotNull Resource resource, @Nullable XStreamContext context) {
        return XmlUtils.fromXML(resource.getInputStream(), context);
    }

    public static <T> T fromXML(@NotNull InputStream input) {
        return (T)XmlUtils.getXStream().fromXML(input);
    }

    public static <T> T fromXML(@NotNull InputStream input, @NotNull Object root) {
        return (T)XmlUtils.getXStream().fromXML(input, root);
    }

    public static <T> T fromXML(@NotNull InputStream input, @Nullable XStreamContext context) {
        return (T)XmlUtils.getXStream().unmarshal(hierarchicalStreamDriver.createReader(input), null, (DataHolder)context);
    }

    public static <T> T fromXML(@NotNull Reader reader) {
        return (T)XmlUtils.getXStream().fromXML(reader);
    }

    public static <T> T fromXML(@NotNull Reader reader, @NotNull Object root) {
        return (T)XmlUtils.getXStream().fromXML(reader, root);
    }

    public static <T> T fromXML(@NotNull Reader reader, @Nullable XStreamContext context) {
        return (T)XmlUtils.getXStream().unmarshal(hierarchicalStreamDriver.createReader(reader), null, (DataHolder)context);
    }

    public static void toXML(@NotNull Object obj, @NotNull String file) {
        XmlUtils.toXML(obj, new File(file));
    }

    public static void toXML(@NotNull Object obj, @NotNull File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            XmlUtils.toXML(obj, osw);
            osw.close();
            fos.close();
        }
        catch (IOException e) {
            String msg = "Unable to serialize object '%s' into XML and write it into file: %s";
            LoggerFactory.getLogger(XmlUtils.class).error(TextUtils.format("Unable to serialize object '%s' into XML and write it into file: %s", obj, file), (Throwable)e);
        }
    }

    @NotNull
    public static String toXML(@NotNull Object obj) {
        return XmlUtils.getXStream().toXML(obj);
    }

    public static void toXML(@NotNull Object obj, @NotNull Writer out) {
        XmlUtils.getXStream().toXML(obj, out);
    }

    public static void toXML(@NotNull Object obj, @NotNull OutputStream out) {
        XmlUtils.getXStream().toXML(obj, out);
    }

    public static void toXML(@NotNull Object obj, @NotNull HierarchicalStreamWriter writer) {
        XmlUtils.getXStream().marshal(obj, writer);
    }

    @NotNull
    public static Resource readResource(@NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context, @NotNull Mapper mapper) {
        Resource resource;
        String path = reader.getAttribute(PATH_ATTRIBUTE);
        String contextBase = (String)context.get((Object)CONTEXT_BASE);
        if (path != null) {
            String contextNearClass;
            String completePath = contextBase != null ? NetUtils.joinUrlPaths(contextBase, path) : path;
            String nearClass = reader.getAttribute(NEAR_CLASS_ATTRIBUTE);
            resource = nearClass != null ? new ClassResource(mapper.realClass(nearClass), completePath) : ((contextNearClass = (String)context.get((Object)CONTEXT_NEAR_CLASS)) != null ? new ClassResource(mapper.realClass(contextNearClass), completePath) : new FileResource(completePath));
        } else {
            String url = reader.getAttribute(URL_ATTRIBUTE);
            if (url != null) {
                String completeURL = contextBase != null ? NetUtils.joinUrlPaths(contextBase, url) : url;
                resource = new UrlResource(completeURL);
            } else {
                throw new UtilityException("Unable to find any Resource type in node attributes: " + reader.getNodeName());
            }
        }
        return resource;
    }

    static {
        xStream = null;
    }
}

