/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.FileUtils;
import com.alee.utils.IOUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.zip.UnzipListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipUtils {
    private ZipUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static void unzip(@NotNull String archive, @NotNull String dst) {
        ZipUtils.unzip(archive, dst, null);
    }

    public static void unzip(@NotNull String archive, @NotNull String dst, @Nullable UnzipListener listener) {
        ZipUtils.unzip(new File(archive), new File(dst), listener);
    }

    public static void unzip(@NotNull File archive, @NotNull File dst) {
        ZipUtils.unzip(archive, dst, null);
    }

    public static void unzip(@NotNull File archive, @NotNull File dst, @Nullable UnzipListener listener) {
        try {
            ZipFile zipFile = new ZipFile(archive);
            if (listener != null) {
                listener.sizeDetermined(zipFile.size());
            }
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            int index = 0;
            while (entries.hasMoreElements()) {
                File extractToFile;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    extractToFile = new File(dst, entry.getName());
                    extractToFile.mkdirs();
                } else {
                    extractToFile = new File(dst, entry.getName());
                    File parent = FileUtils.getParent(extractToFile);
                    if (parent != null && parent.mkdirs()) {
                        extractToFile.createNewFile();
                        IOUtils.copy(zipFile.getInputStream(entry), new FileOutputStream(extractToFile));
                    }
                }
                if (listener == null) continue;
                listener.fileUnzipped(entry, extractToFile, index);
                ++index;
            }
            zipFile.close();
        }
        catch (Exception e) {
            throw new UtilityException("Unable to unzip ZIP archive: " + archive, e);
        }
    }

    @NotNull
    public static String getFileName(@NotNull ZipEntry zipEntry) {
        String name = zipEntry.getName();
        return name.substring(name.lastIndexOf("/") + 1);
    }

    @NotNull
    public static String getFileLocation(@NotNull ZipEntry zipEntry) {
        String name = zipEntry.getName();
        return name.substring(0, name.lastIndexOf("/") + 1);
    }
}

