/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.concurrent;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Supplier;
import java.util.concurrent.ThreadFactory;

public class DaemonThreadFactory
implements ThreadFactory {
    @NotNull
    private final Supplier<String> nameSupplier;

    public DaemonThreadFactory() {
        this("DaemonThread");
    }

    public DaemonThreadFactory(final @NotNull String name) {
        this(new Supplier<String>(){
            private int number = 0;

            @Override
            public synchronized String get() {
                return name + "-" + this.number++;
            }
        });
    }

    public DaemonThreadFactory(@NotNull Supplier<String> nameSupplier) {
        this.nameSupplier = nameSupplier;
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName(this.nameSupplier.get());
        thread.setDaemon(true);
        return thread;
    }
}

