/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.jar;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.FileUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.file.FileDownloadListener;
import com.alee.utils.jar.JarEntry;
import com.alee.utils.jar.JarEntryType;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;

public class JarStructure {
    @NotNull
    protected final String jarLocation;
    @NotNull
    protected final JarEntry root;

    public JarStructure(@NotNull Class jarClass) {
        this(jarClass, null, null, null);
    }

    public JarStructure(@NotNull Class jarClass, @Nullable List<String> allowedExtensions, @Nullable List<String> allowedPackages) {
        this(jarClass, allowedExtensions, allowedPackages, null);
    }

    public JarStructure(@NotNull Class jarClass, @Nullable List<String> allowedExtensions, @Nullable List<String> allowedPackages, @Nullable FileDownloadListener listener) {
        try {
            ZipInputStream zip;
            CodeSource src = jarClass.getProtectionDomain().getCodeSource();
            if (src != null) {
                ZipEntry zipEntry;
                URL jarUrl = src.getLocation();
                URI uri = jarUrl.toURI();
                String scheme = uri.getScheme();
                File jarFile = scheme != null && scheme.equalsIgnoreCase("file") ? new File(uri) : FileUtils.downloadFile(jarUrl.toString(), File.createTempFile(jarUrl.getFile(), ".tmp"), listener);
                this.jarLocation = jarFile.getAbsolutePath();
                this.root = new JarEntry(this, JarEntryType.JAR, jarFile.getName());
                zip = new ZipInputStream(jarUrl.openStream());
                while ((zipEntry = zip.getNextEntry()) != null) {
                    String entryName = zipEntry.getName();
                    if (!this.isAllowedPackage(entryName, allowedPackages) || !zipEntry.isDirectory() && !this.isAllowedExtension(entryName, allowedExtensions)) continue;
                    String[] path = entryName.split("/");
                    JarEntry currentLevel = this.root;
                    for (int i = 0; i < path.length; ++i) {
                        if (i < path.length - 1) {
                            JarEntry child = currentLevel.findChildByName(path[i]);
                            if (child == null) {
                                child = new JarEntry(this, currentLevel, zipEntry, JarEntryType.PACKAGE, path[i]);
                                currentLevel.addChild(child);
                            }
                            currentLevel = child;
                            continue;
                        }
                        String ext = FileUtils.getFileExtPart(path[i], false);
                        JarEntryType type = ext.equals("java") ? JarEntryType.JAVA : (ext.equals("class") ? JarEntryType.CLASS : (!ext.isEmpty() ? JarEntryType.FILE : JarEntryType.PACKAGE));
                        currentLevel.addChild(new JarEntry(this, currentLevel, zipEntry, type, path[i]));
                    }
                }
            } else {
                throw new UtilityException("Unable to retrieve JAR file location");
            }
            zip.close();
        }
        catch (Exception e) {
            throw new UtilityException("Unable to read JAR file", e);
        }
    }

    private boolean isAllowedPackage(@NotNull String entryName, @Nullable List<String> allowedPackages) {
        boolean allowed;
        if (allowedPackages != null && allowedPackages.size() != 0) {
            allowed = false;
            for (String packageStart : allowedPackages) {
                if (!entryName.startsWith(packageStart)) continue;
                allowed = true;
                break;
            }
        } else {
            allowed = true;
        }
        return allowed;
    }

    private boolean isAllowedExtension(@NotNull String entryName, @Nullable List<String> allowedExtensions) {
        return allowedExtensions == null || allowedExtensions.size() == 0 || allowedExtensions.contains(FileUtils.getFileExtPart(entryName, true).toLowerCase(Locale.ROOT));
    }

    @NotNull
    public String getJarLocation() {
        return this.jarLocation;
    }

    @NotNull
    public JarEntry getRoot() {
        return this.root;
    }

    @NotNull
    public List<JarEntry> getChildEntries() {
        return this.root.getChildren();
    }

    @NotNull
    public JarEntry getChildByName(@Nullable String name) {
        return this.root.getChildByName(name);
    }

    @NotNull
    public JarEntry getChildByName(@Nullable String name, boolean recursively) {
        return this.root.getChildByName(name, recursively);
    }

    @Nullable
    public JarEntry findChildByName(@Nullable String name) {
        return this.root.findChildByName(name);
    }

    @Nullable
    public JarEntry findChildByName(@Nullable String name, boolean recursively) {
        return this.root.findChildByName(name, recursively);
    }

    @Nullable
    public JarEntry getClassEntry(@NotNull Class<?> forClass) {
        String[] packages = ReflectUtils.getClassPackages(forClass);
        String classFileName = ReflectUtils.getJavaClassName(forClass);
        int currentPackage = 0;
        JarEntry classEntry = this.getRoot();
        while (classEntry != null) {
            if (currentPackage >= packages.length) {
                classEntry = classEntry.findChildByName(classFileName);
                break;
            }
            classEntry = classEntry.findChildByName(packages[currentPackage]);
            ++currentPackage;
        }
        return classEntry;
    }

    @Nullable
    public JarEntry getPackageEntry(@NotNull Package forPackage) {
        return this.getPackageEntry(forPackage.getName());
    }

    @Nullable
    public JarEntry getPackageEntry(@NotNull String forPackage) {
        String[] packages = ReflectUtils.getPackages(forPackage);
        JarEntry packageEntry = this.getRoot();
        for (String currentPackage : packages) {
            if (packageEntry == null) break;
            packageEntry = packageEntry.findChildByName(currentPackage);
        }
        return packageEntry;
    }

    public void setClassIcon(@NotNull Class<?> forClass, @NotNull Icon icon) {
        JarEntry classEntry = this.getClassEntry(forClass);
        if (classEntry != null) {
            classEntry.setIcon(icon);
        }
    }

    public void setPackageIcon(@NotNull Package forPackage, @NotNull Icon icon) {
        this.setPackageIcon(forPackage.getName(), icon);
    }

    public void setPackageIcon(@NotNull String forPackage, @NotNull Icon icon) {
        JarEntry packageEntry = this.getPackageEntry(forPackage);
        if (packageEntry != null) {
            packageEntry.setIcon(icon);
        }
    }
}

