/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.BiPredicate;
import com.alee.utils.CollectionUtils;
import com.alee.utils.swing.WeakComponentData;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.JComponent;

public class WeakComponentDataOrderedSet<C extends JComponent, E>
extends WeakComponentData<C, LinkedHashSet<E>> {
    public WeakComponentDataOrderedSet(@NotNull String key, int initialCapacity) {
        super(key, initialCapacity);
    }

    public synchronized int size(@NotNull C component) {
        LinkedHashSet set = (LinkedHashSet)this.get(component);
        return set != null ? set.size() : 0;
    }

    public synchronized boolean containsData(@NotNull C component) {
        return CollectionUtils.notEmpty((Collection)this.get(component));
    }

    public synchronized boolean containsData(@NotNull C component, @NotNull E data) {
        LinkedHashSet set = (LinkedHashSet)this.get(component);
        return set != null && set.contains(data);
    }

    public synchronized void add(@NotNull C component, @NotNull E data) {
        LinkedHashSet<E> set = (LinkedHashSet<E>)this.get(component);
        if (set == null) {
            set = new LinkedHashSet<E>(1);
            this.set(component, set);
        }
        set.add(data);
    }

    public synchronized void remove(@NotNull C component, @NotNull E data) {
        LinkedHashSet set = (LinkedHashSet)this.get(component);
        if (set != null && set.remove(data) && set.size() == 0) {
            this.clear(component);
        }
    }

    public synchronized void remove(@NotNull C component, @NotNull E data, @NotNull BiConsumer<C, E> removedDataConsumer) {
        LinkedHashSet set = (LinkedHashSet)this.get(component);
        if (set != null && set.remove(data)) {
            removedDataConsumer.accept(component, data);
            if (set.size() == 0) {
                this.clear(component);
            }
        }
    }

    public synchronized void forEachData(@NotNull BiConsumer<C, E> consumer) {
        for (JComponent component : this.components()) {
            this.forEachData(component, consumer);
        }
    }

    public synchronized void forEachData(@NotNull C component, @NotNull BiConsumer<C, E> consumer) {
        LinkedHashSet set = (LinkedHashSet)this.get(component);
        if (set != null) {
            for (Object data : set) {
                consumer.accept(component, data);
            }
        }
    }

    public synchronized boolean anyDataMatch(@NotNull BiPredicate<C, E> predicate) {
        boolean anyDataMatch = false;
        for (JComponent component : this.components()) {
            if (!this.anyDataMatch(component, predicate)) continue;
            anyDataMatch = true;
            break;
        }
        return anyDataMatch;
    }

    public synchronized boolean anyDataMatch(@NotNull C component, @NotNull BiPredicate<C, E> predicate) {
        boolean anyDataMatch = false;
        LinkedHashSet set = (LinkedHashSet)this.get(component);
        if (set != null) {
            for (Object data : set) {
                if (!predicate.test(component, data)) continue;
                anyDataMatch = true;
                break;
            }
        }
        return anyDataMatch;
    }

    public synchronized boolean allDataMatch(@NotNull BiPredicate<C, E> predicate) {
        boolean allDataMatch = true;
        for (JComponent component : this.components()) {
            if (this.allDataMatch(component, predicate)) continue;
            allDataMatch = false;
            break;
        }
        return allDataMatch;
    }

    public synchronized boolean allDataMatch(@NotNull C component, @NotNull BiPredicate<C, E> predicate) {
        boolean allDataMatch = true;
        LinkedHashSet set = (LinkedHashSet)this.get(component);
        if (set != null) {
            for (Object data : set) {
                if (predicate.test(component, data)) continue;
                allDataMatch = false;
                break;
            }
        }
        return allDataMatch;
    }

    public synchronized boolean noneDataMatch(@NotNull BiPredicate<C, E> predicate) {
        boolean noneDataMatch = true;
        for (JComponent component : this.components()) {
            if (this.noneDataMatch(component, predicate)) continue;
            noneDataMatch = false;
            break;
        }
        return noneDataMatch;
    }

    public synchronized boolean noneDataMatch(@NotNull C component, @NotNull BiPredicate<C, E> predicate) {
        boolean noneDataMatch = true;
        LinkedHashSet set = (LinkedHashSet)this.get(component);
        if (set != null) {
            for (Object data : set) {
                if (!predicate.test(component, data)) continue;
                noneDataMatch = false;
                break;
            }
        }
        return noneDataMatch;
    }
}

