/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.api.annotations.NotNull;
import com.alee.utils.xml.XmlException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Dimension;
import java.util.StringTokenizer;

public class DimensionConverter
extends AbstractSingleValueConverter {
    public static final String SEPARATOR = ",";

    public boolean canConvert(@NotNull Class type) {
        return Dimension.class.isAssignableFrom(type);
    }

    @NotNull
    public String toString(@NotNull Object object) {
        return DimensionConverter.dimensionToString((Dimension)object);
    }

    @NotNull
    public Object fromString(@NotNull String dimension) {
        return DimensionConverter.dimensionFromString(dimension);
    }

    @NotNull
    public static String dimensionToString(Dimension dimension) {
        return dimension.width + SEPARATOR + dimension.height;
    }

    @NotNull
    public static Dimension dimensionFromString(@NotNull String string) {
        Dimension dimension;
        try {
            if (string.contains(SEPARATOR)) {
                StringTokenizer tokenizer = new StringTokenizer(string, SEPARATOR, false);
                int width = Integer.parseInt(tokenizer.nextToken().trim());
                int height = Integer.parseInt(tokenizer.nextToken().trim());
                dimension = new Dimension(width, height);
            } else {
                int width = Integer.parseInt(string);
                dimension = new Dimension(width, width);
            }
        }
        catch (Exception e) {
            throw new XmlException("Unable to parse Dimension: " + string, e);
        }
        return dimension;
    }
}

