/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.accordion;

import com.alee.api.Identifiable;
import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.BoxOrientation;
import com.alee.extended.accordion.AccordionPaneListener;
import com.alee.extended.accordion.WebAccordion;
import com.alee.extended.collapsible.AbstractControlButton;
import com.alee.extended.collapsible.AbstractHeaderPanel;
import com.alee.extended.collapsible.AbstractTitleLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.Stateful;
import com.alee.utils.SwingUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class AccordionPane
extends WebPanel
implements Stateful,
Identifiable {
    @NotNull
    protected final String id;
    @NotNull
    protected JComponent header;
    @Nullable
    protected Component content;

    public AccordionPane(@NotNull WebAccordion accordion, @NotNull String id, @Nullable String title) {
        this(StyleId.accordionPane.at(accordion), accordion, id, null, title, null);
    }

    public AccordionPane(@NotNull WebAccordion accordion, @NotNull String id, @Nullable Icon icon, @Nullable String title) {
        this(StyleId.accordionPane.at(accordion), accordion, id, icon, title, null);
    }

    public AccordionPane(@NotNull WebAccordion accordion, @NotNull String id, @Nullable String title, @Nullable Component content) {
        this(StyleId.accordionPane.at(accordion), accordion, id, null, title, content);
    }

    public AccordionPane(@NotNull WebAccordion accordion, @NotNull String id, @Nullable Icon icon, @Nullable String title, @Nullable Component content) {
        this(StyleId.accordionPane.at(accordion), accordion, id, icon, title, content);
    }

    public AccordionPane(@NotNull StyleId styleId, @NotNull WebAccordion accordion, @NotNull String id, @Nullable String title) {
        this(styleId, accordion, id, null, title, null);
    }

    public AccordionPane(@NotNull StyleId styleId, @NotNull WebAccordion accordion, @NotNull String id, @Nullable Icon icon, @Nullable String title) {
        this(styleId, accordion, id, icon, title, null);
    }

    public AccordionPane(@NotNull StyleId styleId, @NotNull WebAccordion accordion, @NotNull String id, @Nullable String title, @Nullable Component content) {
        this(styleId, accordion, id, null, title, content);
    }

    public AccordionPane(@NotNull StyleId styleId, @NotNull WebAccordion accordion, @NotNull String id, @Nullable Icon icon, @Nullable String title, @Nullable Component content) {
        super(styleId, (LayoutManager)null, new Component[0]);
        this.id = id;
        this.header = this.createHeaderComponent(icon, title);
        this.add((Component)this.header);
        this.content = content;
        if (content != null) {
            this.add(this.content);
        }
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public List<String> getStates() {
        ArrayList<String> states = new ArrayList<String>(3);
        states.add(this.getHeaderPosition().name());
        states.add(this.isExpanded() || this.isInTransition() ? "expanded" : "collapsed");
        if (this.isInTransition()) {
            states.add(this.isExpanded() ? "expanding" : "collapsing");
        }
        return states;
    }

    @NotNull
    public JComponent getHeader() {
        return this.header;
    }

    public void setHeader(@Nullable Icon icon, @Nullable String title) {
        this.setHeader(this.createHeaderComponent(icon, title));
    }

    public void setHeader(@NotNull JComponent header) {
        if (this.header != header) {
            this.remove((Component)this.header);
            this.header = header;
            this.add((Component)this.header);
            SwingUtils.update(this);
        }
    }

    @NotNull
    protected JComponent createHeaderComponent(@Nullable Icon icon, @Nullable String title) {
        AbstractHeaderPanel headerPanel = new AbstractHeaderPanel(StyleId.accordionPaneHeaderPanel.at(this)){

            @Override
            @NotNull
            public BoxOrientation getHeaderPosition() {
                return AccordionPane.this.getHeaderPosition();
            }

            @Override
            public boolean isExpanded() {
                return AccordionPane.this.isExpanded();
            }

            @Override
            public boolean isInTransition() {
                return AccordionPane.this.isInTransition();
            }

            @Override
            protected void onHeaderAction(@NotNull InputEvent e) {
                AccordionPane.this.expandOrCollapse(e);
            }
        };
        headerPanel.add((Component)this.createTitleComponent(headerPanel, icon, title), (Object)"title");
        headerPanel.add((Component)this.createControlComponent(headerPanel), (Object)"control");
        return headerPanel;
    }

    @NotNull
    protected JComponent createTitleComponent(@NotNull JComponent header, @Nullable Icon icon, @Nullable String title) {
        AbstractTitleLabel titleLabel = new AbstractTitleLabel(StyleId.accordionPaneTitleLabel.at(header)){

            @Override
            @NotNull
            public BoxOrientation getHeaderPosition() {
                return AccordionPane.this.getHeaderPosition();
            }

            @Override
            public boolean isExpanded() {
                return AccordionPane.this.isExpanded();
            }

            @Override
            public boolean isInTransition() {
                return AccordionPane.this.isInTransition();
            }
        };
        titleLabel.setIcon(icon);
        titleLabel.setText(title);
        return titleLabel;
    }

    @NotNull
    protected JComponent createControlComponent(@NotNull JComponent header) {
        return new AbstractControlButton(StyleId.accordionPaneControlButton.at(header)){

            @Override
            @NotNull
            public BoxOrientation getHeaderPosition() {
                return AccordionPane.this.getHeaderPosition();
            }

            @Override
            public boolean isExpanded() {
                return AccordionPane.this.isExpanded();
            }

            @Override
            public boolean isInTransition() {
                return AccordionPane.this.isInTransition();
            }

            @Override
            protected void onControlAction(@NotNull ActionEvent e) {
                AccordionPane.this.expandOrCollapse(e);
            }
        };
    }

    protected void expandOrCollapse(@NotNull AWTEvent e) {
        Container parent = this.getParent();
        if (parent instanceof WebAccordion) {
            WebAccordion accordion = (WebAccordion)parent;
            if (this.isExpanded()) {
                accordion.collapsePane(this.getId());
            } else {
                accordion.expandPane(this.getId());
            }
            if ((e instanceof MouseEvent || e instanceof ActionEvent) && accordion.isShowing()) {
                if (accordion.isFocusable()) {
                    accordion.requestFocusInWindow();
                } else {
                    this.transferFocus();
                }
            }
        }
    }

    @Nullable
    public Component getContent() {
        return this.content;
    }

    public void setContent(@Nullable Component content) {
        if (this.content != content) {
            if (this.content != null) {
                this.remove(this.content);
            }
            this.content = content;
            if (this.content != null) {
                this.add(this.content);
            }
            SwingUtils.update(this);
        }
    }

    @NotNull
    public BoxOrientation getHeaderPosition() {
        Container parent = this.getParent();
        return parent instanceof WebAccordion ? ((WebAccordion)parent).getHeaderPosition() : BoxOrientation.top;
    }

    public boolean isExpanded() {
        Container parent = this.getParent();
        return parent instanceof WebAccordion && ((WebAccordion)parent).isPaneExpanded(this.getId());
    }

    public boolean setExpanded(boolean expanded) {
        Container parent = this.getParent();
        return parent instanceof WebAccordion && ((WebAccordion)parent).setPaneExpanded(this.getId(), expanded);
    }

    public boolean expand() {
        Container parent = this.getParent();
        return parent instanceof WebAccordion && ((WebAccordion)parent).expandPane(this.getId());
    }

    public boolean isCollapsed() {
        Container parent = this.getParent();
        return parent instanceof WebAccordion && ((WebAccordion)parent).isPaneCollapsed(this.getId());
    }

    public boolean setCollapsed(boolean collapsed) {
        Container parent = this.getParent();
        return parent instanceof WebAccordion && ((WebAccordion)parent).setPaneCollapsed(this.getId(), collapsed);
    }

    public boolean collapse() {
        Container parent = this.getParent();
        return parent instanceof WebAccordion && ((WebAccordion)parent).collapsePane(this.getId());
    }

    public boolean isInTransition() {
        Container parent = this.getParent();
        return parent instanceof WebAccordion && ((WebAccordion)parent).isPaneInTransition(this.getId());
    }

    public int getMinimumPaneContentSize() {
        Container parent = this.getParent();
        return parent instanceof WebAccordion ? ((WebAccordion)parent).getMinimumPaneContentSize() : 0;
    }

    public void addAccordionPaneListener(@NotNull AccordionPaneListener listener) {
        this.listenerList.add(AccordionPaneListener.class, listener);
    }

    public void removeAccordionPaneListener(@NotNull AccordionPaneListener listener) {
        this.listenerList.remove(AccordionPaneListener.class, listener);
    }

    public void fireExpanding(@NotNull WebAccordion accordion) {
        for (AccordionPaneListener listener : (AccordionPaneListener[])this.listenerList.getListeners(AccordionPaneListener.class)) {
            listener.expanding(accordion, this);
        }
    }

    public void fireExpanded(@NotNull WebAccordion accordion) {
        for (AccordionPaneListener listener : (AccordionPaneListener[])this.listenerList.getListeners(AccordionPaneListener.class)) {
            listener.expanded(accordion, this);
        }
    }

    public void fireCollapsing(@NotNull WebAccordion accordion) {
        for (AccordionPaneListener listener : (AccordionPaneListener[])this.listenerList.getListeners(AccordionPaneListener.class)) {
            listener.collapsing(accordion, this);
        }
    }

    public void fireCollapsed(@NotNull WebAccordion accordion) {
        for (AccordionPaneListener listener : (AccordionPaneListener[])this.listenerList.getListeners(AccordionPaneListener.class)) {
            listener.collapsed(accordion, this);
        }
    }
}

