/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.accordion;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.accordion.AccordionLayout;
import com.alee.extended.accordion.AccordionModel;
import com.alee.extended.accordion.AccordionPane;
import com.alee.extended.accordion.AccordionPaneState;
import com.alee.extended.accordion.AccordionState;
import com.alee.extended.accordion.WebAccordion;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebAccordionModel
implements AccordionModel,
PropertyChangeListener,
ContainerListener {
    @Nullable
    protected WebAccordion accordion;
    @NotNull
    protected Map<String, AccordionPaneState> states = new HashMap<String, AccordionPaneState>();
    @NotNull
    protected Comparator<AccordionPane> newToOldPaneComparator = new Comparator<AccordionPane>(){

        @Override
        public int compare(AccordionPane pane1, AccordionPane pane2) {
            return new Long(WebAccordionModel.this.getPaneState(pane2.getId()).getTime()).compareTo(WebAccordionModel.this.getPaneState(pane1.getId()).getTime());
        }
    };

    @Override
    public void install(@NotNull WebAccordion accordion) {
        if (this.accordion != null) {
            throw new RuntimeException("WebAccordionModel is already installed");
        }
        this.accordion = accordion;
        this.accordion.addPropertyChangeListener(this);
        this.accordion.addContainerListener(this);
        this.validateStates();
    }

    @Override
    public void uninstall(@NotNull WebAccordion multiSplitPane) {
        if (this.accordion == null) {
            throw new RuntimeException("WebAccordionModel is not yet installed");
        }
        this.accordion.removeContainerListener(this);
        this.accordion.removePropertyChangeListener(this);
        this.accordion = null;
    }

    @NotNull
    protected WebAccordion getAccordion() {
        if (this.accordion != null) {
            return this.accordion;
        }
        throw new RuntimeException("WebAccordionModel is not yet installed");
    }

    @Override
    @NotNull
    public AccordionState getAccordionState() {
        Map<String, AccordionPaneState> states;
        if (this.accordion != null) {
            states = new HashMap<String, AccordionPaneState>();
            for (Map.Entry<String, AccordionPaneState> state : this.states.entrySet()) {
                if (!this.accordion.containsPane(state.getKey())) continue;
                states.put(state.getKey(), state.getValue());
            }
        } else {
            states = this.states;
        }
        return new AccordionState(states);
    }

    @Override
    public void setAccordionState(@NotNull AccordionState accordionState) {
        this.states = accordionState.states();
        this.validateStates();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        if (Objects.equals((Object)property, (Object[])new Object[]{"minimumExpandedPaneCount", "maximumExpandedPaneCount"})) {
            this.validateStates();
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        AccordionLayout layout;
        AccordionPane pane = (AccordionPane)e.getChild();
        if (!this.states.containsKey(pane.getId())) {
            this.states.put(pane.getId(), new AccordionPaneState(pane.getId(), false));
        }
        this.validateStates();
        if (this.accordion != null && (layout = this.accordion.getLayout()) != null) {
            layout.paneAdded(this.accordion, pane);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        AccordionLayout layout;
        AccordionPane pane = (AccordionPane)e.getChild();
        this.states.remove(pane.getId());
        this.validateStates();
        if (this.accordion != null && (layout = this.accordion.getLayout()) != null) {
            layout.paneRemoved(this.accordion, pane);
        }
    }

    protected void validateStates() {
        block3: {
            List<AccordionPane> expanded;
            block4: {
                if (this.accordion == null) break block3;
                for (AccordionPane pane : this.accordion.getPanes()) {
                    if (this.states.containsKey(pane.getId())) continue;
                    this.states.put(pane.getId(), new AccordionPaneState(pane.getId(), false));
                }
                expanded = this.getExpandedPanes();
                List<AccordionPane> collapsed = this.getCollapsedPanes();
                if (expanded.size() >= this.accordion.getMinimumExpandedPaneCount()) break block4;
                CollectionUtils.sort(collapsed, this.newToOldPaneComparator);
                int toExpand = Math.min(collapsed.size(), this.accordion.getMinimumExpandedPaneCount() - expanded.size());
                for (int i = 0; i < toExpand; ++i) {
                    this.expandPane(collapsed.get(i).getId());
                }
                break block3;
            }
            if (expanded.size() <= this.accordion.getMaximumExpandedPaneCount()) break block3;
            CollectionUtils.sort(expanded, this.newToOldPaneComparator);
            int toCollapse = expanded.size() - this.accordion.getMaximumExpandedPaneCount();
            for (int i = 0; i < toCollapse; ++i) {
                this.collapsePane(expanded.get(i).getId());
            }
        }
    }

    @NotNull
    protected AccordionPaneState getPaneState(@NotNull String id) {
        if (this.states.containsKey(id)) {
            return this.states.get(id);
        }
        throw new RuntimeException("Cannot find AccordionPaneState for identifier: " + id);
    }

    @Override
    @Nullable
    public AccordionPane getFirstExpandedPane() {
        AccordionPane firstExpanded = null;
        WebAccordion accordion = this.getAccordion();
        for (int i = 0; i < accordion.getPaneCount(); ++i) {
            AccordionPane pane = accordion.getPane(i);
            if (!this.isPaneExpanded(pane.getId())) continue;
            firstExpanded = pane;
            break;
        }
        return firstExpanded;
    }

    @Override
    @Nullable
    public AccordionPane getLastExpandedPane() {
        AccordionPane lastExpanded = null;
        WebAccordion accordion = this.getAccordion();
        for (int i = accordion.getPaneCount() - 1; i >= 0; --i) {
            AccordionPane pane = accordion.getPane(i);
            if (!this.isPaneExpanded(pane.getId())) continue;
            lastExpanded = pane;
            break;
        }
        return lastExpanded;
    }

    @Override
    @NotNull
    public List<AccordionPane> getExpandedPanes() {
        WebAccordion accordion = this.getAccordion();
        ArrayList<AccordionPane> expandedPanes = new ArrayList<AccordionPane>(accordion.getPaneCount());
        for (int i = 0; i < accordion.getPaneCount(); ++i) {
            AccordionPane pane = accordion.getPane(i);
            if (!this.isPaneExpanded(pane.getId())) continue;
            expandedPanes.add(pane);
        }
        return expandedPanes;
    }

    @Override
    @NotNull
    public List<String> getExpandedPaneIds() {
        WebAccordion accordion = this.getAccordion();
        ArrayList<String> expandedIds = new ArrayList<String>(accordion.getPaneCount());
        for (int i = 0; i < accordion.getPaneCount(); ++i) {
            AccordionPane pane = accordion.getPane(i);
            if (!this.isPaneExpanded(pane.getId())) continue;
            expandedIds.add(pane.getId());
        }
        return expandedIds;
    }

    @Override
    public void setExpandedPaneIds(@NotNull List<String> ids) {
        WebAccordion accordion = this.getAccordion();
        for (int i = 0; i < accordion.getPaneCount(); ++i) {
            AccordionPane pane = accordion.getPane(i);
            if (ids.contains(pane.getId())) {
                if (!this.isPaneCollapsed(pane.getId())) continue;
                this.expandUnconditionally(pane.getId());
                continue;
            }
            if (!this.isPaneExpanded(pane.getId())) continue;
            this.collapseUnconditionally(pane.getId());
        }
        this.validateStates();
    }

    @Override
    @NotNull
    public int[] getExpandedPaneIndices() {
        WebAccordion accordion = this.getAccordion();
        ArrayList<Integer> expandedIndices = new ArrayList<Integer>(accordion.getPaneCount());
        for (int i = 0; i < accordion.getPaneCount(); ++i) {
            AccordionPane pane = accordion.getPane(i);
            if (!this.isPaneExpanded(pane.getId())) continue;
            expandedIndices.add(i);
        }
        return CollectionUtils.toIntArray(expandedIndices);
    }

    @Override
    public void setExpandedPaneIndices(@NotNull int[] indices) {
        WebAccordion accordion = this.getAccordion();
        ArrayList expanded = CollectionUtils.asList((int[])indices);
        for (int i = 0; i < accordion.getPaneCount(); ++i) {
            AccordionPane pane = accordion.getPane(i);
            if (expanded.contains(i)) {
                if (!this.isPaneCollapsed(pane.getId())) continue;
                this.expandUnconditionally(pane.getId());
                continue;
            }
            if (!this.isPaneExpanded(pane.getId())) continue;
            this.collapseUnconditionally(pane.getId());
        }
        this.validateStates();
    }

    @Override
    public boolean isPaneExpanded(@NotNull String id) {
        return this.getPaneState(id).isExpanded();
    }

    @Override
    public boolean expandPane(@NotNull String id) {
        boolean wasExpanded;
        if (this.isPaneCollapsed(id)) {
            WebAccordion accordion = this.getAccordion();
            List<AccordionPane> expanded = this.getExpandedPanes();
            if (expanded.size() < accordion.getMaximumExpandedPaneCount()) {
                this.expandUnconditionally(id);
                wasExpanded = true;
            } else if (expanded.size() > 0) {
                CollectionUtils.sort(expanded, this.newToOldPaneComparator);
                this.collapseUnconditionally(expanded.get(0).getId());
                this.expandUnconditionally(id);
                wasExpanded = true;
            } else {
                wasExpanded = false;
            }
        } else {
            wasExpanded = false;
        }
        return wasExpanded;
    }

    protected void expandUnconditionally(@NotNull String id) {
        this.getPaneState(id).setExpanded(true);
        WebAccordion accordion = this.getAccordion();
        AccordionPane pane = accordion.getPane(id);
        AccordionLayout layout = accordion.getLayout();
        if (layout != null) {
            layout.expandPane(accordion, id);
        } else {
            pane.fireExpanding(accordion);
            accordion.fireExpanding(pane);
            SwingUtils.update(accordion);
            pane.fireExpanded(accordion);
            accordion.fireExpanded(pane);
        }
    }

    @Override
    @NotNull
    public List<AccordionPane> getCollapsedPanes() {
        WebAccordion accordion = this.getAccordion();
        ArrayList<AccordionPane> collapsedPanes = new ArrayList<AccordionPane>(accordion.getPaneCount());
        for (int i = 0; i < accordion.getPaneCount(); ++i) {
            AccordionPane pane = accordion.getPane(i);
            if (!this.isPaneCollapsed(pane.getId())) continue;
            collapsedPanes.add(pane);
        }
        return collapsedPanes;
    }

    @Override
    @NotNull
    public List<String> getCollapsedPaneIds() {
        WebAccordion accordion = this.getAccordion();
        ArrayList<String> collapsedIds = new ArrayList<String>(accordion.getPaneCount());
        for (int i = 0; i < accordion.getPaneCount(); ++i) {
            AccordionPane pane = accordion.getPane(i);
            if (!this.isPaneCollapsed(pane.getId())) continue;
            collapsedIds.add(pane.getId());
        }
        return collapsedIds;
    }

    @Override
    @NotNull
    public int[] getCollapsedPaneIndices() {
        WebAccordion accordion = this.getAccordion();
        ArrayList<Integer> collapsedIndices = new ArrayList<Integer>(accordion.getPaneCount());
        for (int i = 0; i < accordion.getPaneCount(); ++i) {
            AccordionPane pane = accordion.getPane(i);
            if (!this.isPaneCollapsed(pane.getId())) continue;
            collapsedIndices.add(i);
        }
        return CollectionUtils.toIntArray(collapsedIndices);
    }

    @Override
    public boolean isPaneCollapsed(@NotNull String id) {
        return !this.isPaneExpanded(id);
    }

    @Override
    public boolean collapsePane(@NotNull String id) {
        boolean wasCollapsed;
        if (this.isPaneExpanded(id)) {
            WebAccordion accordion = this.getAccordion();
            List<AccordionPane> expanded = this.getExpandedPanes();
            List<AccordionPane> collapsed = this.getCollapsedPanes();
            if (expanded.size() > accordion.getMinimumExpandedPaneCount()) {
                this.collapseUnconditionally(id);
                wasCollapsed = true;
            } else if (collapsed.size() > 0) {
                CollectionUtils.sort(collapsed, this.newToOldPaneComparator);
                this.expandUnconditionally(collapsed.get(0).getId());
                this.collapseUnconditionally(id);
                wasCollapsed = true;
            } else {
                wasCollapsed = false;
            }
        } else {
            wasCollapsed = false;
        }
        return wasCollapsed;
    }

    protected void collapseUnconditionally(@NotNull String id) {
        this.getPaneState(id).setExpanded(false);
        WebAccordion accordion = this.getAccordion();
        AccordionPane pane = accordion.getPane(id);
        AccordionLayout layout = accordion.getLayout();
        if (layout != null) {
            layout.collapsePane(accordion, id);
        } else {
            pane.fireCollapsing(accordion);
            accordion.fireCollapsing(pane);
            SwingUtils.update(accordion);
            pane.fireCollapsed(accordion);
            accordion.fireCollapsed(pane);
        }
    }
}

